//	Zinc Interface Library - SYS.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_SYSTEM_BUTTON --------------------------------------------------

UIW_SYSTEM_BUTTON::UIW_SYSTEM_BUTTON(UI_ITEM *item) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_NO_FLAGS,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY),
	syFlags(SYF_NO_FLAGS)
{
	// Initialize the system button information.
	UIW_SYSTEM_BUTTON::Information(INITIALIZE_CLASS, NULL);

	// Add the pop-up menu items.
	for (int i = 0; item[i].text; i++)
		Add(new UIW_POP_UP_ITEM(item[i].text, item[i].flags, BTF_NO_3D,
			WOF_NO_FLAGS, (USER_FUNCTION)item[i].data, item[i].value));
}

UIW_SYSTEM_BUTTON::UIW_SYSTEM_BUTTON(SYF_FLAGS _syFlags) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_NO_FLAGS,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY),
	syFlags(_syFlags)
{
	// Initialize the system button information.
	UIW_SYSTEM_BUTTON::Information(INITIALIZE_CLASS, NULL);
}

UIW_SYSTEM_BUTTON::~UIW_SYSTEM_BUTTON(void)
{
	text = NULL;
	bitmapArray = NULL;
}

#ifdef _WINDOWS
EVENT_TYPE UIW_SYSTEM_BUTTON::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		UI_WINDOW_OBJECT::Event(event);
		dwStyle = WS_SYSMENU;
		parent->Information(SET_DWSTYLE, &dwStyle);
		break;

	case S_CREATE:
		if (!FlagSet(syFlags, SYF_GENERIC))
		{
			menu.screenID = GetSystemMenu(parent->screenID, FALSE);
			while (DeleteMenu(menu.screenID, 0, MF_BYPOSITION))
				;
			for (UI_WINDOW_OBJECT *object = menu.First(); object; object = object->Next())
				object->Event(event);
		}
		break;

	case S_ADD_OBJECT:
	case S_SUBTRACT_OBJECT:
		menu.Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#else
static char *_tNormal = "[-]";
static UCHAR _gNormal[29] =
{
	7, 3,
	BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK,
	BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK,
	BLACK, BLACK, BLACK, BLACK, BLACK, BLACK, BLACK
};

EVENT_TYPE UIW_SYSTEM_BUTTON::Event(const UI_EVENT &event)
{
	static initializedTime = FALSE;
	static UI_TIME lastTime;
	if (!initializedTime)
	{
		lastTime.Import();
		initializedTime = TRUE;
	}

	// Initialize the generic system button.
	static UIW_POP_UP_MENU *_genericMenu = NULL;
	if (!_genericMenu)
	{
		_genericMenu = new UIW_POP_UP_MENU(0, 0, WNF_NO_FLAGS, WOF_BORDER,
			WOAF_TEMPORARY | WOAF_NO_DESTROY);
		*_genericMenu
			+ new UIW_POP_UP_ITEM("&Restore", MNIF_RESTORE)
			+ new UIW_POP_UP_ITEM("&Move", MNIF_MOVE)
			+ new UIW_POP_UP_ITEM("&Size", MNIF_SIZE)
			+ new UIW_POP_UP_ITEM("Mi&nimize", MNIF_MINIMIZE)
			+ new UIW_POP_UP_ITEM("Ma&ximize", MNIF_MAXIMIZE)
			+ new UIW_POP_UP_ITEM
			+ new UIW_POP_UP_ITEM("&Close", MNIF_CLOSE);
	}

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_SYSTEM_BUTTON);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		UI_WINDOW_OBJECT::Event(event);
		if (display->isText)
		{
			text = _tNormal;
			true.right = true.left + 2;
			true.bottom = true.top;
		}
		else
		{
			text = NULL;
			UCHAR *bitmap = _gNormal;
			bitmapWidth = bitmap[0];
			bitmapHeight = bitmap[1];
			bitmapArray = &bitmap[2];
			true.bottom = --true.top + (display->cellHeight - display->preSpace - display->postSpace);
			true.right = --true.left + (display->cellHeight - display->preSpace - display->postSpace);
		}
		break;

	case S_ADD_OBJECT:
	case S_SUBTRACT_OBJECT:
		menu.Event(event);
		break;

	case L_BEGIN_SELECT:
		{
		UI_TIME time;
		if (time - lastTime < doubleClickRate && !parent->parent)
		{
			UI_EVENT tEvent = event;
			while (ccode != L_END_SELECT)
			{
				eventManager->Get(tEvent);
				ccode = LogicalEvent(tEvent, ID_SYSTEM_BUTTON);
			}
			eventManager->Put(UI_EVENT(S_CLOSE));
			break;
		}
		lastTime = time;
		}
		// Continue to L_SELECT.
	case L_SELECT:
		if (FlagSet(syFlags, SYF_GENERIC) || menu.First())
		{
			UIW_POP_UP_MENU *sMenu = FlagSet(syFlags, SYF_GENERIC) ? _genericMenu : &menu;
			if (windowManager->Index(sMenu) != -1)
				break;
			sMenu->parent = this;
	 		sMenu->RegionConvert(sMenu->relative, TRUE);
			if (FlagSet(parent->woStatus, WOS_MINIMIZED))
				true = parent->true;
			sMenu->relative.left = true.left;
			sMenu->relative.top = true.bottom;
			if (display->isText)
				sMenu->relative.top++;
			if (sMenu->Current())
				sMenu->Current()->woStatus &= ~WOS_CURRENT;
			if (sMenu->First())
				sMenu->First()->woStatus |= WOS_CURRENT;
			sMenu->true = sMenu->relative;
			for (UI_WINDOW_OBJECT *object = sMenu->First(); object; object = object->Next())
				switch (object->NumberID())
				{
				case NUMID_OPT_RESTORE:
					if (FlagSet(parent->woStatus, WOS_MAXIMIZED | WOS_MINIMIZED))
						object->woFlags &= ~WOF_NON_SELECTABLE;
					else
						object->woFlags |= WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_MOVE:
					if (FlagSet(parent->woAdvancedFlags, WOAF_NO_MOVE) ||
						FlagSet(parent->woStatus, WOS_MAXIMIZED))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_SIZE:
					if (FlagSet(parent->woAdvancedFlags, WOAF_NO_SIZE) ||
						FlagSet(parent->woStatus, WOS_MAXIMIZED | WOS_MINIMIZED))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_MINIMIZE:
				case NUMID_OPT_MAXIMIZE:
					if (FlagSet(parent->woStatus, WOS_MAXIMIZED | WOS_MINIMIZED) ||
						(FlagSet(parent->woAdvancedFlags, WOAF_NO_SIZE) && object->NumberID() == NUMID_OPT_MAXIMIZE))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;

				case NUMID_OPT_CLOSE:
					if (parent->parent || FlagSet(parent->woAdvancedFlags, WOAF_LOCKED))
						object->woFlags |= WOF_NON_SELECTABLE;
					else
						object->woFlags &= ~WOF_NON_SELECTABLE;
					break;
				}
			*windowManager + sMenu;
		}
		else
			UIW_BUTTON::Event(event);
		break;

	case S_DISPLAY_INACTIVE:
	case S_DISPLAY_ACTIVE:
		if (display->isText)
		{
			lastPalette = LogicalPalette(ccode);
			UIW_BUTTON::DrawItem(event, ccode);
			woStatus &= ~WOS_REDISPLAY;
			break;
		}
		// Continue to default.
	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

UIW_SYSTEM_BUTTON *UIW_SYSTEM_BUTTON::Generic(void)
{
	return (new UIW_SYSTEM_BUTTON(SYF_GENERIC));
}

void *UIW_SYSTEM_BUTTON::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_SYSTEM_BUTTON;
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_SYSTEM_BUTTON;
		windowID[1] = ID_BUTTON;
		menu.parent = this;
		numberID = NUMID_SYSTEM;
		strcpy(stringID, "NUMID_SYSTEM");
		woAdvancedFlags |= WOAF_NON_CURRENT;
		hotKey = HOT_KEY_SYSTEM;
		depth = 1;
		break;

	case GET_NUMBERID_OBJECT:
	case GET_STRINGID_OBJECT:
		{
		void *match = UI_WINDOW_OBJECT::Information(request, data, objectID);
		if (!match)
			match = menu.Information(request, data, objectID);
		data = match;
		}
		break;

	case CHANGED_FLAGS:
#ifdef _WINDOWS
		if (parent)
			parent->Information(SET_DWSTYLE, &dwStyle);
#endif
		break;

	case GET_FLAGS:
	case SET_FLAGS:
	case CLEAR_FLAGS:
		if (objectID && objectID != ID_SYSTEM_BUTTON)
			data = UIW_BUTTON::Information(request, data, objectID);
		else if (request == GET_FLAGS && !data)
			data = &syFlags;
		else if (request == GET_FLAGS)
			*(SYF_FLAGS *)data = syFlags;
		else if (request == SET_FLAGS)
			syFlags |= *(SYF_FLAGS *)data;
		else
			syFlags &= ~(*(SYF_FLAGS *)data);
		break;

	case PRINT_INFORMATION:
	case PRINT_USER_FUNCTION:
		menu.Information(request, data, objectID);
		break;

	default:
		data = UIW_BUTTON::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_SYSTEM_BUTTON::UIW_SYSTEM_BUTTON(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_NO_FLAGS,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY)
{
	// Initialize the system button information.
	UIW_SYSTEM_BUTTON::Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_BUTTON::Information(INITIALIZE_CLASS, NULL);
	UIW_SYSTEM_BUTTON::Information(INITIALIZE_CLASS, NULL);
}

void UIW_SYSTEM_BUTTON::Load(const char *, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Load the system button information.
	file->Load(&syFlags);
	if (!FlagSet(syFlags, SYF_GENERIC))
		menu.Load(NULL, directory, file);
}

void UIW_SYSTEM_BUTTON::Store(const char *, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Store the system button information.
	file->Store(syFlags);
	if (!FlagSet(syFlags, SYF_GENERIC))
		menu.Store(NULL, directory, file);

	// Flag the object as being used.
	if (objectTable)
	{
		for (int i = 0; objectTable[i].data; i++)
			if (objectTable[i].value == searchID)
			{
				objectTable[i].flags = TRUE;
				break;
			}
	}
}
#endif
