//	Zinc Interface Library - TITLE.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_TITLE ----------------------------------------------------------

UIW_TITLE::UIW_TITLE(char *text, WOF_FLAGS _woFlags) :
	UIW_BUTTON(0, 0, 0, text, BTF_DOWN_CLICK | BTF_NO_TOGGLE | BTF_NO_3D,
	_woFlags | WOF_BORDER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION)
{
	// Initialize the title information.
	UIW_TITLE::Information(INITIALIZE_CLASS, NULL);
}

UIW_TITLE::~UIW_TITLE(void)
{
	// No title information needs to be reset.
}

char *UIW_TITLE::DataGet(void)
{
 	return (text);
}

void UIW_TITLE::DataSet(char *_text)
{
	// Reset the title.
	if (text && text != _text && !FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
		delete text;
	if (text == _text || FlagSet(woFlags, WOF_NO_ALLOCATE_DATA))
		text = _text;
	else
		text = ui_strdup(_text);

	// Redisplay the string.
	if (parent->screenID)
#ifdef _WINDOWS
		SendMessage(parent->screenID, WM_SETTEXT, 0, (LONG)text);
#else
		Event(UI_EVENT(S_REDISPLAY));
#endif
}

#ifdef _WINDOWS
EVENT_TYPE UIW_TITLE::Event(const UI_EVENT &event)
{
	// Initialize the title.
	if (event.type == S_INITIALIZE)
	{
		UI_WINDOW_OBJECT::Event(event);
		dwStyle = WS_CAPTION;
		parent->Information(SET_TITLE, this);
		parent->Information(SET_DWSTYLE, &dwStyle);
	}
	return (event.type);
}
#else
EVENT_TYPE UIW_TITLE::Event(const UI_EVENT &event)
{
	static UI_TIME lastTime;

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_TITLE);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		value = FlagSet(parent->woStatus, WOS_MAXIMIZED) ? L_RESTORE : L_MAXIMIZE;
		UI_WINDOW_OBJECT::Event(event);
		if (display->isText)
			true.bottom = true.top;
		else
		{
			true.left--; true.right++;
			true.bottom = --true.top + (display->cellHeight - display->preSpace - display->postSpace);
		}
		break;

	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		if (display->isText)
			lastPalette = NULL;
		UI_WINDOW_OBJECT::Event(event);
		// Continue to S_REDISPLAY.
	case S_REDISPLAY:
		if (FlagSet(woStatus, WOS_REDISPLAY) || ccode == S_REDISPLAY)
		{
			UI_REGION region = true;
			if (FlagSet(woFlags, WOF_BORDER))
				DrawBorder(screenID, region, FALSE, ccode);
			DrawText(screenID, region, text, lastPalette, TRUE, ccode);
			woStatus &= ~WOS_REDISPLAY;
		}
		break;

	case L_BEGIN_SELECT:
		{
		UI_TIME currentTime;
		if (currentTime - lastTime < doubleClickRate &&
			!FlagSet(parent->woAdvancedFlags, WOAF_NO_SIZE))
		{
			UI_EVENT event(value);
			event.rawCode = 0;
			event.data = parent;
			eventManager->Put(event);
			break;
		}
		if (!FlagSet(parent->woAdvancedFlags, WOAF_NO_MOVE) &&
			!FlagSet(parent->woStatus, WOS_MAXIMIZED))
			parent->Event(UI_EVENT(L_MOVE, 0x0001, event.position));
		lastTime = currentTime;
		}
		break;

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_TITLE::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_TITLE;
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_TITLE;
		windowID[1] = ID_BUTTON;
		numberID = NUMID_TITLE;
		strcpy(stringID, "NUMID_TITLE");
		woAdvancedFlags |= WOAF_NON_CURRENT;
		font = FNT_SYSTEM_FONT;
		depth = 0;
		break;

	case CHANGED_FLAGS:
#ifdef _WINDOWS
		if (parent)
		{
			parent->Information(SET_TITLE, this);
			parent->Information(SET_DWSTYLE, &dwStyle);
		}
#endif
		break;

	case GET_TEXT:
		if (!data)
			return (DataGet());
		*(char **)data = DataGet();
		break;

	case SET_TEXT:
		DataSet((char *)data);
		break;

	default:
		data = UIW_BUTTON::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_TITLE::UIW_TITLE(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_BUTTON(0, 0, 0, NULL, BTF_DOWN_CLICK | BTF_NO_TOGGLE | BTF_NO_3D,
	WOF_BORDER | WOF_JUSTIFY_CENTER | WOF_SUPPORT_OBJECT | WOF_NON_FIELD_REGION)
{
	// Initialize the title information.
	UIW_TITLE::Load(name, directory, file);
	UIW_TITLE::Information(INITIALIZE_CLASS, NULL);
}

void UIW_TITLE::Load(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *file)
{
	// Load the title information.
	file->Load(&text);
}

void UIW_TITLE::Store(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *file)
{
	// Store the title information.
	file->Store(text);

	// Flag the object as being used.
	if (objectTable)
	{
		for (int i = 0; objectTable[i].data; i++)
			if (objectTable[i].value == searchID)
			{
				objectTable[i].flags = TRUE;
				break;
			}
	}
}
#endif

