//	Zinc Interface Library Designer - UI_DSN.HPP
//	COPYRIGHT (C) 1990, 1991.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef UI_DSN_HPP
#define UI_DSN_HPP

// Give frame class access to protected members.
#define UIF_WINDOW						UIW_FRAME_WINDOW
#define UIF_BORDER						UIW_FRAME_WINDOW
#define UIF_PROMPT						UIW_FRAME_WINDOW
#define UIF_BUTTON						UIW_FRAME_WINDOW
#define UIF_TITLE						UIW_FRAME_WINDOW
#define UIF_MAXIMIZE_BUTTON				UIW_FRAME_WINDOW
#define UIF_MINIMIZE_BUTTON				UIW_FRAME_WINDOW
#define UIF_ICON						UIW_FRAME_WINDOW
#define UIF_POP_UP_MENU					UIW_FRAME_WINDOW
#define UIF_POP_UP_ITEM					UIW_FRAME_WINDOW
#define UIF_PULL_DOWN_MENU				UIW_FRAME_WINDOW
#define UIF_PULL_DOWN_ITEM				UIW_FRAME_WINDOW
#define UIF_SYSTEM_BUTTON				UIW_FRAME_WINDOW
#define UIF_STRING						UIW_FRAME_WINDOW
#define UIF_DATE						UIW_FRAME_WINDOW
#define UIF_FORMATTED_STRING			UIW_FRAME_WINDOW
#define UIF_BIGNUM						UIW_FRAME_WINDOW
#define UIF_INTEGER						UIW_FRAME_WINDOW
#define UIF_REAL						UIW_FRAME_WINDOW
#define UIF_TIME						UIW_FRAME_WINDOW
#define UIF_TEXT						UIW_FRAME_WINDOW
#define UIF_GROUP						UIW_FRAME_WINDOW
#define UIF_VT_LIST						UIW_FRAME_WINDOW
#define UIF_HZ_LIST						UIW_FRAME_WINDOW
#define UIF_COMBO_BOX					UIW_FRAME_WINDOW
#define UIF_SCROLL_BAR					UIW_FRAME_WINDOW
#define UIF_TOOL_BAR					UIW_FRAME_WINDOW
#define UIF_WINDOW_OBJECT				UIW_FRAME_WINDOW
#define UIF_CONTROL						CONTROL_WINDOW

#ifndef UI_WIN_HPP
#include <ui_win.hpp>
#endif

// Special object ID's for designer.
const OBJECTID ID_RADIO_BUTTON			= 3000;
const OBJECTID ID_CHECK_BOX				= 3001;
const OBJECTID ID_HSCROLL				= 3002;
const OBJECTID ID_VSCROLL				= 3003;
const OBJECTID ID_CSCROLL				= 3004;
const OBJECTID ID_HELP_BAR				= 3005;
const OBJECTID ID_OBJECT_LIST			= 3006;
const OBJECTID ID_STORAGE_COMBO_BOX		= 3007;

// Designer event types.
const USER_EVENT FILE_FIRST			  	= 10000;
const USER_EVENT FILE_NEW			  	= 10000;
const USER_EVENT FILE_OPEN			  	= 10001;
const USER_EVENT FILE_SAVE			  	= 10002;
const USER_EVENT FILE_SAVE_AS		  	= 10003;
const USER_EVENT FILE_CHANGE_DRIVE	  	= 10004;
const USER_EVENT FILE_CHANGE_DIRECTORY	= 10005;
const USER_EVENT FILE_CHANGE_FILE		= 10006;
const USER_EVENT FILE_DELETE			= 10007;
const USER_EVENT FILE_PREFERENCES		= 10009;
const USER_EVENT FILE_EXIT				= 10011;
const USER_EVENT FILE_SET_NAME			= 10012;
const USER_EVENT FILE_CHANGE_PATH	  	= 10013;
const USER_EVENT FILE_LAST			  	= 10013;

const USER_EVENT EDIT_FIRST				= 10100;
const USER_EVENT EDIT_OBJECT			= 10100;
const USER_EVENT EDIT_CUT				= 10101;
const USER_EVENT EDIT_COPY				= 10102;
const USER_EVENT EDIT_PASTE				= 10103;
const USER_EVENT EDIT_DELETE			= 10104;
const USER_EVENT EDIT_MOVE				= 10105;
const USER_EVENT EDIT_SIZE				= 10106;
const USER_EVENT EDIT_LAST				= 10106;

const USER_EVENT RESOURCE_FIRST		 	= 10200;
const USER_EVENT RESOURCE_CREATE	 	= 10200;
const USER_EVENT RESOURCE_LOAD		 	= 10201;
const USER_EVENT RESOURCE_SELECT		= 10202;
const USER_EVENT RESOURCE_ADD			= 10203;
const USER_EVENT RESOURCE_EDIT		 	= 10204;
const USER_EVENT RESOURCE_CLEAR			= 10205;
const USER_EVENT RESOURCE_DELETE	 	= 10206;
const USER_EVENT RESOURCE_TEST		 	= 10207;
const USER_EVENT RESOURCE_STORE		 	= 10208;
const USER_EVENT RESOURCE_STORE_AS	 	= 10209;
const USER_EVENT RESOURCE_END_TEST	 	= 10210;
const USER_EVENT RESOURCE_LAST		 	= 10210;

const USER_EVENT UTIL_FIRST				= 10300;
const USER_EVENT UTIL_BITMAP			= 10300;
const USER_EVENT BITMAP_RESIZE			= 10301;
const USER_EVENT IMAGE_LIST				= 10302;
const USER_EVENT IMAGE_SELECT			= 10303;
const USER_EVENT IMAGE_DISPLAY			= 10304;
const USER_EVENT UTIL_HELP				= 10305;
const USER_EVENT CONTEXT_LIST			= 10306;
const USER_EVENT CONTEXT_SELECT			= 10307;
const USER_EVENT UTIL_LAST				= 10307;

const USER_EVENT OPTION_NEW				= 10400;
const USER_EVENT OPTION_LOAD			= 10401;
const USER_EVENT OPTION_SAVE			= 10402;
const USER_EVENT OPTION_SAVE_AS			= 10403;
const USER_EVENT OPTION_DELETE			= 10404;
const USER_EVENT OPTION_EXIT			= 10405;
const USER_EVENT OPTION_OK				= 10406;
const USER_EVENT OPTION_CANCEL			= 10407;
const USER_EVENT OPTION_HELP			= 10408;
const USER_EVENT OPTION_ADD_ITEM		= 10410;

const USER_EVENT DIALOG_FIRST			= 10700;
const USER_EVENT DIALOG_OK				= 10700;
const USER_EVENT DIALOG_CANCEL			= 10701;
const USER_EVENT DIALOG_YES				= 10702;
const USER_EVENT DIALOG_NO				= 10703;
const USER_EVENT DIALOG_ABORT			= 10704;
const USER_EVENT DIALOG_RETRY			= 10705;
const USER_EVENT DIALOG_LAST			= 10706;

const USER_EVENT IMAGE_PENCIL			= 10800;
const USER_EVENT IMAGE_BRUSH			= 10801;
const USER_EVENT IMAGE_LINE				= 10802;
const USER_EVENT IMAGE_RECTANGLE		= 10803;
const USER_EVENT IMAGE_FILL_RECTANGLE	= 10804;
const USER_EVENT IMAGE_ELLIPSE			= 10805;
const USER_EVENT IMAGE_FILL_ELLIPSE		= 10806;
const USER_EVENT IMAGE_FILL				= 10807;

const USER_EVENT D_SET_TEXT				= 10800;
const USER_EVENT D_CONFIG_CHANGED		= 9999;
const USER_EVENT D_DELETE_OBJECT		= 10802;
const USER_EVENT D_DRAG_UP 				= 10803;
const USER_EVENT D_DRAG_DOWN			= 10804;


class HELP_BAR : public UI_WINDOW_OBJECT
{
public:
	HELP_BAR(void);

	void Update(UI_WINDOW_OBJECT *helpObject);
	EVENT_TYPE Event(const UI_EVENT &event);

	static UI_WINDOW_OBJECT *New(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *)
	{ return new HELP_BAR(); }
	virtual void Store(const char *, UI_STORAGE *, UI_STORAGE_OBJECT *)
	{}

protected:
	UI_HELP_CONTEXT helpContext;
	char *text;
};

class EXPORT CONTROL_WINDOW : public UIW_WINDOW
{
public:
	CONTROL_WINDOW(void);

	virtual EVENT_TYPE Event(const UI_EVENT &event);
	void SetTitle(void);

protected:
	UI_WINDOW_OBJECT *currentObject;
	OBJECTID createID;
	OBJECTID repeatCreateID;
	int paste;

	UIW_PULL_DOWN_MENU *mainMenu;
	UIW_TOOL_BAR *toolBar;
	UIW_TOOL_BAR *statusBar;
	UIW_STRING *objectString;
	UIW_STRING *idString;
	UIW_STRING *posString;
	UIW_STRING *sizeString;
	UIW_STRING *placeString;
	HELP_BAR *helpBar;

	int AddConfigObjects(void);
	void EditOption(const UI_EVENT &event);
	void FileOption(const UI_EVENT &event);
	void ResourceOption(const UI_EVENT &event);
	void UpdatePlaceString(OBJECTID objectID);
	void UpdateStatusBar(void);
	void UtilOption(const UI_EVENT &event);
};

class EXPORT FILE_WINDOW : public UIW_WINDOW
{
public:
	FILE_WINDOW(EVENT_TYPE ccode);
	virtual EVENT_TYPE Event(const UI_EVENT &event);

private:
	EVENT_TYPE option;
	UIW_STRING *name;
	UIW_STRING *directory;
	UIW_VT_LIST *drives;
	UIW_VT_LIST *directories;
	UIW_VT_LIST *files;
	HELP_BAR *helpBar;
};

class UIW_FRAME_WINDOW : public UIW_WINDOW
{
public:
	UIW_FRAME_WINDOW(char *name, UI_WINDOW_OBJECT *editObject,
		UI_WINDOW_OBJECT *listItem = NULL);

	EVENT_TYPE Event(const UI_EVENT &event);

protected:
	UI_WINDOW_OBJECT *editObject;
	UI_WINDOW_OBJECT *listItem;
	UIF_FLAGS oldFlags;
	HELP_BAR *helpBar;
};


// Configuration (preferences) --------------------------------------------

const USHORT TOOL_BITMAP 				= 1;
const USHORT TOOL_TEXT 					= 2;
const USHORT TOOL_BITMAP_AND_TEXT 		= 3;

const USHORT OPTION_TOOL_BAR			= 0x0001;
const USHORT OPTION_STATUS_BAR			= 0x0002;
const USHORT OPTION_HELP_BAR			= 0x0004;
const USHORT OPTION_MENU_BITMAPS		= 0x0008;

struct ZINC_SIGNATURE
{
	char copyrightNotice[64];
  	UCHAR majorVersion;
	UCHAR minorVersion;
	USHORT magicNumber;
};

struct TOOL_BUTTON_DATA
{
	char objectName[32];
  	char bitmapName[32];
	USHORT createID;
  	int used;
};

class TOOL_BUTTON_ELEMENT : public UI_ELEMENT
{
public:
	TOOL_BUTTON_ELEMENT(TOOL_BUTTON_DATA &_data)
	{ data = _data; }
	TOOL_BUTTON_DATA data;
};


struct CONFIG_DATA
{
	ZINC_SIGNATURE signature;
	USHORT options;
	USHORT backups;
	USHORT numeratorX;
	USHORT denominatorX;
	USHORT numeratorY;
	USHORT denominatorY;
	USHORT toolBar;
	UI_LIST toolList;
};

class PREFERENCES_WINDOW : public UIW_WINDOW
{
public:
	PREFERENCES_WINDOW(void);
	EVENT_TYPE Event(const UI_EVENT &event);
	UIW_INTEGER *backupsField;
	UIW_BUTTON *bitmapButton;
	UIW_BUTTON *textButton;
	UIW_BUTTON *bothButton;
	UIW_BUTTON *toolBarButton;
	UIW_BUTTON *statusBarButton;
	UIW_BUTTON *helpBarButton;
	UIW_BUTTON *bitmapsButton;
	UIW_HZ_LIST *objectsList;
	UIW_INTEGER *numeratorX;
	UIW_INTEGER *denominatorX;
	UIW_INTEGER *numeratorY;
	UIW_INTEGER *denominatorY;

protected:
	HELP_BAR *helpBar;
};

class RESOURCE_WINDOW : public UIW_WINDOW
{
public:
  	RESOURCE_WINDOW(EVENT_TYPE ccode, UI_WINDOW_OBJECT *resource = NULL);
	EVENT_TYPE Event(const UI_EVENT &event);
	UIW_STRING *nameField;

protected:
	EVENT_TYPE option;
	UI_WINDOW_OBJECT *currentResource;
	HELP_BAR *helpBar;
};

class OBJECT_LIST : public UIW_VT_LIST
{
public:
	OBJECT_LIST(int left, int top, int width, int height);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
	void GetObjects(UIW_WINDOW *window);
	void SaveObjects(UIW_WINDOW *window);
	void NewObject(UI_WINDOW_OBJECT *object);

	OBJECT_LIST(const char *name, UI_STORAGE *file = NULL, UI_STORAGE_OBJECT *object = NULL);
	static UI_WINDOW_OBJECT *New(const char *name, UI_STORAGE *file, UI_STORAGE_OBJECT *object)
		{ return (new OBJECT_LIST(name, file, object)); }

protected:
	UI_LIST deleteList;
	UI_LIST addList;
	int orderChanged;

	static EVENT_TYPE SelectChild(UI_WINDOW_OBJECT *object, UI_EVENT &event,
		EVENT_TYPE ccode);
};

class STORAGE_COMBO_BOX : public UIW_COMBO_BOX
{
public:
	STORAGE_COMBO_BOX(const char *name, UI_STORAGE *file = NULL, UI_STORAGE_OBJECT *object = NULL);
	static UI_WINDOW_OBJECT *New(const char *name, UI_STORAGE *file, UI_STORAGE_OBJECT *object)
		{ return (new STORAGE_COMBO_BOX(name, file, object)); }
	virtual void Store(const char *name, UI_STORAGE *file = NULL, UI_STORAGE_OBJECT *object = NULL);
	void LoadBox(char *currentName);
	void LoadBox(UI_HELP_CONTEXT helpNumber);

	char *GetName(void);
	int GetID(void);

protected:
	OBJECTID childID;
};

class HELP_EDITOR : public UIW_WINDOW
{
	friend class CONTEXT_WINDOW;
public:
  	HELP_EDITOR(char *_helpName = NULL);
	virtual EVENT_TYPE Event(const UI_EVENT &event);

protected:
	char *helpName;
	UIW_STRING *titleField;
	UIW_TEXT *textField;

	void HELP_EDITOR::LoadContext(void);
};

// Bitmap Editor ---------------------------------------------------------
const INFO_REQUEST FLOOD_COLOR			= 0x010B;

enum BITMAP_ID
{
	ID_COLOR_BITMAP,
	ID_EDIT_BITMAP,
	ID_VIEW_BITMAP,
  	ID_SCREEN_BITMAP,
	ID_LEFT_BITMAP,
	ID_RIGHT_BITMAP
};

class UIW_BITMAP : public UI_WINDOW_OBJECT
{
	friend class BITMAP_EDITOR;
public:
	UIW_BITMAP *leftObject;
	UIW_BITMAP *rightObject;
	UIW_BITMAP *screenObject;
	UIW_BITMAP *viewObject;
	UIW_BITMAP *editObject;

	UIW_BITMAP(int left, int top, char *bitmapName, BITMAP_ID bitmapID,
		int ratioWidth = 1, int ratioHeight = 1);
	virtual ~UIW_BITMAP(void);
	virtual EVENT_TYPE Event(const UI_EVENT &event);
	virtual void *Information(INFO_REQUEST request, void *data, OBJECTID objectID = 0);

protected:
	BITMAP_ID bitmapID;
	EVENT_TYPE drawStyle;
	char *bitmapName;
	int bitmapWidth;
	int bitmapHeight;
	UCHAR *bitmapArray;
#if defined(_WINDOWS) | defined(_Windows)
	HBITMAP colorBitmap, monoBitmap;
#endif
	int ratioWidth, ratioHeight;
	static COLOR leftColor, rightColor, screenColor;

	EVENT_TYPE DrawItem(const UI_EVENT &event);
//	void Fill(int x, int y, UCHAR oldColor, UCHAR newColor);
//	void GetImageRegion(int column, int line, UCHAR color);
	void Pixel(int x, int y, UCHAR color);
};

class BITMAP_EDITOR : public UIW_WINDOW
{
	friend class IMAGE_WINDOW;
public:
  	BITMAP_EDITOR(OBJECTID imageID = ID_BITMAP_IMAGE);
	virtual EVENT_TYPE Event(const UI_EVENT &event);

protected:
	int bitmapWidth, bitmapHeight;
	UCHAR *bitmapArray;
	OBJECTID imageID;
	char *imageName;
	UIW_BITMAP *colorBitmap;
	UIW_BITMAP *editBitmap;
	UIW_BITMAP *editBackground;
	UIW_BITMAP *viewBitmap;
	UIW_BITMAP *viewBackground;
	UIW_PROMPT *screenPrompt;
	UIW_BITMAP *screenBitmap;
	UIW_PROMPT *leftRightPrompt;
	UIW_BITMAP *leftColor; 
	UIW_BITMAP *rightColor;

	void LoadImage(void);
};

class IMAGE_WINDOW : public UIW_WINDOW
{
public:
  	IMAGE_WINDOW(USER_EVENT _mode, BITMAP_EDITOR *_editor);
	EVENT_TYPE Event(const UI_EVENT &event);
	OBJECTID imageID;
	UIW_STRING *nameField;
	UIW_HZ_LIST *imageMatrix;
	UIW_COMBO_BOX *typeField;
	USER_EVENT mode;
	BITMAP_EDITOR *editor;
	UIW_INTEGER *widthField;
	UIW_INTEGER *heightField;
	HELP_BAR *helpBar;
};


typedef UIF_FLAGS DIF_FLAGS;
const DIF_FLAGS DIF_OK					= 0x0001;
const DIF_FLAGS DIF_YES					= 0x0002;
const DIF_FLAGS DIF_NO					= 0x0004;
const DIF_FLAGS DIF_CANCEL				= 0x0008;
const DIF_FLAGS DIF_ABORT				= 0x0010;
const DIF_FLAGS DIF_RETRY				= 0x0020;

class DIALOG_WINDOW : public UIW_WINDOW
{
public:
	DIALOG_WINDOW(char *title, char *icon, DIF_FLAGS diFlags, char *format, ...);

	EVENT_TYPE Responce(void);
};

class CONTEXT_WINDOW : public UIW_WINDOW
{
public:
  	CONTEXT_WINDOW(USER_EVENT _mode, HELP_EDITOR *_editor);
	EVENT_TYPE Event(const UI_EVENT &event);
	UIW_STRING *nameField;
	UIW_HZ_LIST *contextMatrix;
	USER_EVENT mode;
	HELP_EDITOR *editor;
	HELP_BAR *helpBar;
};

// Global variables.
extern CONFIG_DATA *_config;
extern CONTROL_WINDOW *_controlWindow;
extern int _dosError;
extern void *_errorMemory;
extern UI_ITEM _objectTable[];
extern int _saveNeeded;
extern UI_STORAGE *_storage;
extern UI_PALETTE_MAP _textPaletteTable[];
extern UI_ITEM _toolData[];
extern UI_ITEM _userTable[];


//Global funtions.
extern int AddAllowed(UI_WINDOW_OBJECT *parent, UI_WINDOW_OBJECT *child);
extern void Center(UIW_WINDOW *window);
extern UI_WINDOW_OBJECT *CreateObject(OBJECTID objectID, UIF_FLAGS flags = 0);
extern void GetDecimalFlags(UIW_VT_LIST *flagsList, NMF_FLAGS *nmFlags);
extern EVENT_TYPE GetErrorResponce();
extern void GetFlags(UIW_VT_LIST *flagsList, UIF_FLAGS *objectFlag[], UIW_WINDOW *window = NULL);
extern char *HelpBarMessage(UI_HELP_CONTEXT helpContext);
extern void ReplaceString(char **oldString, char *newString);
extern void SaveDecimalFlags(UIW_VT_LIST *flagsList, NMF_FLAGS *nmFlags);
extern void SaveFile(char *newName = NULL, int memErr = FALSE);
extern void SaveFlags(UIW_VT_LIST *flagsList, UIF_FLAGS *objectFlag[], UIW_WINDOW *window = NULL);
#endif // UI_DSN_HPP

