# DISPLAY tutorial makefile

# Uses Microsoft C++ 7.00 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_M70;C:\C700\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\C700\INCLUDE

#    make -fmicrosft.mak test.exe      (makes the test tutorial program)

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=cl
LINK=link
DOS_CPP_OPTS=-c -AL -BATCH
DOS_LINK_OPTS=/NOI /BATCH /STACK:5120 /SEGMENTS:256

## Libraries:
DOS_OBJS=
DOS_LIBS=zil graphics oldnames


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<


all: test.exe


test.exe: test.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+test.obj
$*,NUL,$(DOS_LIBS),NUL
<<
