# HELLO tutorial makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak hello1.exe      (makes the hello1 tutorial program)
#    make -fzortech.mak hello2.exe      (makes the hello2 tutorial program)
#    make -fzortech.mak hello3.exe      (makes the hello3 tutorial program)
#    make -fzortech.mak hellog.exe      (makes program to generate HELLO.DAT file)
#    make -fzortech.mak whello1.exe     (makes the Windows hello1 program)
#    make -fzortech.mak whello2.exe     (makes the Windows hello2 program)
#    make -fzortech.mak whello3.exe     (makes the Windows hello3 program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: hello1.exe hello2.exe hello3.exe hellog.exe whello1.exe whello2.exe whello3.exe


hello1.exe: hello1.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+hello1.obj,$*, ,$(DOS_LIBS),NUL


hello2.exe: hello2.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+hello2.obj,$*, ,$(DOS_LIBS),NUL


hello3.exe: hello3.obj hello.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+hello3.obj+hello.obj,$*, ,$(DOS_LIBS),NUL


hellog.exe: hellog.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+hellog.obj,$*, ,$(DOS_LIBS),NUL


whello1.exe: hello1.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+hello1.obw,$*, ,$(WIN_LIBS),whello.def
	rc -k whello.rc $*.exe


whello2.exe: hello2.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+hello2.obw,$*, ,$(WIN_LIBS),whello.def
	rc -k whello.rc $*.exe


whello3.exe: hello3.obw hello.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+hello3.obw+hello.obw,$*, ,$(WIN_LIBS),whello.def
	rc -k whello.rc $*.exe
