//	DRAW.C (PERSIST) - Draw functions (compiler specific).
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "draw.h"

#if defined (_WINDOWS) || defined (_Windows)
#include <windows.h>

extern HDC _hDC;

void DrawCircle(int column, int line, int radius)
{
	Arc(_hDC, column - radius, line - radius, column + radius,
		line + radius, column, line - radius, column, line - radius);
}
void DrawRectangle(int left, int top, int right, int bottom)
{
	Rectangle(_hDC, left, top, right, bottom);
}
void DrawTriangle(int *triangle)
{
	MoveTo(_hDC, triangle[0], triangle[1]);
	LineTo(_hDC, triangle[2], triangle[3]);
	LineTo(_hDC, triangle[4], triangle[5]);
	LineTo(_hDC, triangle[6], triangle[7]);
}

#else

#ifdef _MSC_VER
#include <stdlib.h>
#include <graph.h>

void InitializeDisplay(void)
{
	if (!_setvideomode(_MAXRESMODE))
		exit(1);
}
void RestoreDisplay(void)
{
	_setvideomode(_DEFAULTMODE);
}
void DrawCircle(int column, int line, int radius)
{
	_ellipse(_GBORDER, column - radius, line - radius,
		column + radius, line + radius);
}
void DrawRectangle(int left, int top, int right, int bottom)
{
	_rectangle(_GBORDER, left, top, right, bottom);
}
void DrawTriangle(int *triangle)
{
	_polygon(_GBORDER, (struct _xycoord *)triangle, 4);
}
#endif

#ifdef __ZTC__
#include <stdlib.h>
#include <fg.h>

void InitializeDisplay(void)
{
	if (!fg_init())
		exit(1);
}
void RestoreDisplay(void)
{
	fg_term();
}
void DrawCircle(int column, int line, int radius)
{
	fg_drawellipse(FG_WHITE, FG_MODE_SET, ~0, column, line,
		radius, radius, 0, 3600, fg.displaybox);
}
void DrawRectangle(int left, int top, int right, int bottom)
{
	fg_box_t box;
	box[FG_X1] = left;
	box[FG_Y1] = top;
	box[FG_X2] = right;
	box[FG_Y2] = bottom;
	fg_drawbox(FG_WHITE, FG_MODE_SET, ~0, FG_LINE_SOLID,
		box, fg.displaybox);
}
void DrawTriangle(int *triangle)
{
	fg_drawpolygon(FG_WHITE, FG_MODE_SET, ~0, FG_LINE_SOLID,
		3, triangle, fg.displaybox);
}
#endif

#ifdef __BORLANDC__
#include <stdlib.h>
#include <graphics.h>

void InitializeDisplay(void)
{
	int mode;
	int driver = DETECT;
	initgraph(&driver, &mode, NULL);
	if (graphresult() != grOk)
		exit(1);
}
void RestoreDisplay(void)
{
	closegraph();
}
void DrawCircle(int column, int line, int radius)
{
	circle(column, line, radius);
}
void DrawRectangle(int left, int top, int right, int bottom)
{
	rectangle(left, top, right, bottom);
}
void DrawTriangle(int *triangle)
{
	drawpoly(4, triangle);
}
#endif

#endif
