# PERSIST tutorial makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak persist1.exe      (makes the persist1 tutorial program)
#    make -fzortech.mak persist2.exe      (makes the persist2 tutorial program)
#    make -fzortech.mak persist3.exe      (makes the persist3 tutorial program)
#    make -fzortech.mak persist4.exe      (makes the persist4 tutorial program)
#    make -fzortech.mak persist5.exe      (makes the persist5 tutorial program)
#    make -fzortech.mak persist6.exe      (makes the persist6 tutorial program)
#    make -fzortech.mak persist7.exe      (makes the persist7 tutorial program)
#    make -fzortech.mak persist8.exe      (makes the persist8 tutorial program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.c.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.c.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: persist1.exe persist2.exe persist3.exe persist4.exe persist5.exe persist6.exe persist7.exe persist8.exe


persist1.exe: persist1.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist1.obj,$*, ,$(DOS_LIBS),NUL


persist2.exe: persist2.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist2.obj+draw.obj,$*, ,$(DOS_LIBS),NUL


persist3.exe: persist3.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist3.obj+draw.obj,$*, ,$(DOS_LIBS),NUL


persist4.exe: persist4.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist4.obj+draw.obj,$*, ,$(DOS_LIBS),NUL


persist5.exe: persist5.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist5.obj+draw.obj,$*, ,$(DOS_LIBS),NUL


persist6.exe: persist6.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist6.obj+draw.obj,$*, ,$(DOS_LIBS),NUL


persist7.exe: persist7.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+persist7.obj+draw.obj,$*, ,$(DOS_LIBS),NUL


persist8.exe: persist8.obw draw.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+persist8.obw+draw.obw,$*, ,$(WIN_LIBS),persist8.def
	rc -k persist8.rc $*.exe
