# WORD tutorial makefile

# Uses Microsoft C++ 7.00 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_M70;C:\C700\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\C700\INCLUDE

#    make -fmicrosft.mak word1a.exe      (makes the word1a tutorial program)
#    make -fmicrosft.mak word1b.exe      (makes the word1b tutorial program)
#    make -fmicrosft.mak word2.exe       (makes the word2 tutorial program)
#    make -fmicrosft.mak word3.exe       (makes the word3 tutorial program)
#    make -fmicrosft.mak wword2.exe      (makes the Windows word2 program)
#    make -fmicrosft.mak wword3.exe      (makes the Windows word3 program)

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=cl
LINK=link
DOS_CPP_OPTS=-c -AL -BATCH
DOS_LINK_OPTS=/NOI /BATCH /STACK:5120 /SEGMENTS:256
WIN_CPP_OPTS=-c -AL -BATCH -Gw -DWINVER=0x0300
WIN_LINK_OPTS=/NOD /NOI /BATCH /STACK:5120 /SEGMENTS:256

## Libraries:
DOS_OBJS=
DOS_LIBS=zil graphics oldnames
WIN_OBJS=
WIN_LIBS=zilw libw llibcew oldnames


.c.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -Fo$*.obw $<


all: word1a.exe word1b.exe word2.exe word3.exe wword2.exe wword3.exe


word1a.exe: word1a.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+word1a.obj
$*,NUL,$(DOS_LIBS),NUL
<<


word1b.exe: word1b.obj list.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+word1b.obj+list.obj
$*,NUL,$(DOS_LIBS),NUL
<<


word2.exe: word2.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+word2.obj
$*,NUL,$(DOS_LIBS),NUL
<<


word3.exe: word3.obj word_win.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+word3.obj+word_win.obj
$*,NUL,$(DOS_LIBS),NUL
<<


wword2.exe: word2.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+word2.obw
$*,NUL,$(WIN_LIBS),wword.def
<<
	rc -30 -k wword.rc $*.exe


wword3.exe: word3.obw word_win.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+word3.obw+word_win.obw
$*,NUL,$(WIN_LIBS),wword.def
<<
	rc -30 -k wword.rc $*.exe
