# WORD tutorial makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak word1a.exe      (makes the word1a tutorial program)
#    make -fzortech.mak word1b.exe      (makes the word1b tutorial program)
#    make -fzortech.mak word2.exe       (makes the word2 tutorial program)
#    make -fzortech.mak word3.exe       (makes the word3 tutorial program)
#    make -fzortech.mak wword2.exe      (makes the Windows word2 program)
#    make -fzortech.mak wword3.exe      (makes the Windows word3 program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.c.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: word1a.exe word1b.exe word2.exe word3.exe wword2.exe wword3.exe


word1a.exe: word1a.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+word1a.obj,$*, ,$(DOS_LIBS),NUL


word1b.exe: word1b.obj list.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+word1b.obj+list.obj,$*, ,$(DOS_LIBS),NUL


word2.exe: word2.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+word2.obj,$*, ,$(DOS_LIBS),NUL


word3.exe: word3.obj word_win.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+word3.obj+word_win.obj,$*, ,$(DOS_LIBS),NUL


wword2.exe: word2.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+word2.obw,$*, ,$(WIN_LIBS),wword.def
	rc -k wword.rc $*.exe


wword3.exe: word3.obw word_win.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+word3.obw+word_win.obw,$*, ,$(WIN_LIBS),wword.def
	rc -k wword.rc $*.exe
