# ZINCAPP tutorial makefile

# Uses Borland C++ 3.00 and Zinc Interface Library Version 3.00 

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB

#    make -fborland.mak zincapp.exe      (makes the zincapp tutorial program)
#    make -fborland.mak wzincapp.exe     (makes the Windows zincapp program)

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bcc
LINK=tlink
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
WIN_CPP_OPTS=-c -ml -O -WE -w
WIN_LINK_OPTS=/c /C /Twe /x

## Libraries:
DOS_OBJS=c0l
DOS_LIBS=zil graphics emu mathl cl
WIN_OBJS=c0wl
WIN_LIBS=zilw mathwl import cwl


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }


all: zincapp.exe wzincapp.exe


zincapp.exe: zincapp.obj control.obj display.obj window.obj event.obj help.obj support.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+zincapp.obj+control.obj+display.obj+window.obj+event.obj+help.obj+support.obj
$*, ,$(DOS_LIBS)
!


wzincapp.exe: zincapp.obw control.obw display.obw window.obw event.obw help.obw support.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+zincapp.obw+control.obw+display.obw+window.obw+event.obw+help.obw+support.obw
$*, ,$(WIN_LIBS),wzincapp.def
!
	rc wzincapp.rc $<
