//	EVENT.CPP (ZINCAPP) - This file contains the "Event" options.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include <ui_win.hpp>
#include "zincapp.hpp"

void CONTROL_WINDOW::OptionEvent(EVENT_TYPE)
{
	// Create the event monitor.
	*windowManager
		+ new EVENT_MONITOR;
}

EVENT_MONITOR::EVENT_MONITOR(void) :
	UIW_WINDOW(2, 1, 38, 9)
{
	userFlags = MSG_EVENT_MONITOR;
#ifdef _WINDOWS
	windowsMessage[0] = new UIW_STRING(15, 1, 5, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	windowsMessage[1] = new UIW_STRING(15, 2, 5, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	windowsMessage[2] = new UIW_STRING(15, 3, 9, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	windowsMessage[3] = new UIW_STRING(15, 4, 5, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	windowsMessage[4] = new UIW_STRING(20, 4, 5, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
#else
	kEvent.type = mEvent.type = sEvent.type = 0;
	kEvent.rawCode = mEvent.rawCode = sEvent.rawCode = 0xFFFF;
	keyboard[0] = new UIW_STRING(14, 1, 5, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	keyboard[1] = new UIW_STRING(20, 1, 3, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	keyboard[2] = new UIW_STRING(25, 1, 2, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	mouse[0] = new UIW_STRING(14, 3, 5, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	mouse[1] = new UIW_STRING(20, 3, 4, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
	mouse[2] = new UIW_STRING(25, 3, 4, "", 10, STF_NO_FLAGS, WOF_NON_SELECTABLE);
#endif
	system = new UIW_STRING(14, 5, 20, "", 20, STF_NO_FLAGS, WOF_NON_SELECTABLE);

	// Attach the sub-window objects to the event monitor.
	*this
		+ new UIW_BORDER
		+ new UIW_MAXIMIZE_BUTTON
		+ new UIW_MINIMIZE_BUTTON
		+ new UIW_SYSTEM_BUTTON(SYF_GENERIC)
		+ new UIW_TITLE("Event monitor")
#ifdef _WINDOWS
		+ new UIW_PROMPT(2, 1, "Message: ")
		+ windowsMessage[0]
		+ new UIW_PROMPT(2, 2, "wParam: ")
		+ windowsMessage[1]
		+ new UIW_PROMPT(2, 3, "lParam: ")
		+ windowsMessage[2]
		+ new UIW_PROMPT(2, 4, "Position: ")
		+ windowsMessage[3] + windowsMessage[4]
#else
		+ new UIW_PROMPT(2, 1, "Last key: ")
		+ keyboard[0] + keyboard[1] + keyboard[2]
		+ new UIW_PROMPT(2, 3, "Last mouse: ")
		+ mouse[0] + mouse[1] + mouse[2]
#endif
		+ new UIW_PROMPT(2, 5, "Last event: ")
		+ system;
}

EVENT_TYPE EVENT_MONITOR::Event(const UI_EVENT &event)
{
	// Declare the event type/name pairs.
	static struct EVENT_PAIR
	{
		LOGICAL_EVENT type;
		char *name;
	} eventTable[] =
	{
		// Raw events.
		{ E_KEY,				"Key" },
		{ E_MOUSE,				"Mouse" },
		{ E_CURSOR,				"Cursor" },
		{ E_MSWINDOWS,			"MSWindows" },

		// System events.
		{ S_ERROR,				"Error" },
		{ S_UNKNOWN,			"Unmapped Event" },
		{ S_NO_OBJECT,			"No object" },
		{ S_CONTINUE,			"Create" },
		{ S_MINIMIZE,			"Minimize" },
		{ S_MAXIMIZE,			"Maximize" },
		{ S_RESTORE,			"Restore" },
		{ S_INITIALIZE,			"Initialize" },
		{ S_DEINITIALIZE,		"De-initialize" },
		{ S_CREATE,				"Create" },
		{ S_CLOSE,				"Close" },
		{ S_CLOSE_TEMPORARY,	"Close Temporary" },
		{ S_REDISPLAY,			"Redisplay" },
		{ S_NON_CURRENT,		"Non-Current" },
		{ S_REGION_DEFINE,		"Region Define" },
		{ S_MOVE,				"Move" },
		{ S_SIZE,				"Size" },
		{ S_POSITION,			"Position" },
		{ S_CURRENT,			"Current" },
		{ S_DISPLAY_ACTIVE,		"Display Active" },
		{ S_DISPLAY_INACTIVE,	"Display Inactive" },
		{ S_VSCROLL,			"Scroll Vertical" },
		{ S_HSCROLL,			"Scroll Horizontal" },
		{ S_VSCROLL_SET,		"Scroll Vertical Set" },
		{ S_HSCROLL_SET,		"Scroll Horizontal Set" },
		{ S_VSCROLL_CHECK,		"Scroll Vertical Check" },
		{ S_HSCROLL_CHECK,		"Scroll Horizontal Check" },
		{ S_ADD_OBJECT,			"Add Object" },
		{ S_SUBTRACT_OBJECT,	"Subtract Object" },
		{ S_RESET_DISPLAY,		"Reset Display" },

		// Logical events.
		{ L_VIEW,				"View" },
		{ L_SELECT,				"Select" },
		{ L_BEGIN_SELECT,		"Begin Select" },
		{ L_CONTINUE_SELECT,	"Continue Select" },
		{ L_END_SELECT,			"End Select" },
		{ L_BEGIN_ESCAPE,		"Begin Escape" },
		{ L_CONTINUE_ESCAPE,	"Continue Escape" },
		{ L_END_ESCAPE,			"End Escape" },
		{ L_HELP,				"Help" },
		{ L_CANCEL,				"Cancel" },
		{ L_EXIT,				"Exit" },
		{ L_EXIT_FUNCTION,		"Exit Function" },
		{ L_UP,					"Up" },
		{ L_DOWN,				"Down" },
		{ L_LEFT,				"Left" },
		{ L_RIGHT,				"Right" },
		{ L_PREVIOUS,			"Previous" },
		{ L_NEXT,				"Next" },
		{ L_FIRST,				"First" },
		{ L_LAST,				"Last" },
		{ L_TOP,				"Top" },
		{ L_BOTTOM,				"Bottom" },
		{ L_PGUP,				"Page Up" },
		{ L_PGDN,				"Page Down" },
		{ L_BEGIN_MARK,			"Begin Mark" },
		{ L_CONTINUE_MARK,		"Continue Mark" },
		{ L_END_MARK,			"End Mark" },
		{ L_CUT,				"Cut" },
		{ L_PASTE,				"Paste" },
		{ L_CUT_PASTE,			"Cut/Paste" },
		{ L_MARK,				"Mark" },
		{ L_COPY_MARK,			"Copy" },
		{ L_DELETE,				"Delete" },
		{ L_DELETE_WORD,		"Delete Word" },
		{ L_DELETE_EOL,			"Delete to End of Line" },
		{ L_INSERT_TOGGLE,		"Insert Toggle" },
		{ L_WORD_LEFT,			"Word Left" },
		{ L_WORD_RIGHT,			"Word Right" },
		{ L_BOL,				"Beginning of Line" },
		{ L_EOL,				"End of Line" },

		{ S_CANCEL,				"Cancel" },
		{ S_CASCADE,			"Cascade Windows" },
		{ S_CHANGE,				"Change" },
		{ L_RESTORE,			"Restore" },
		{ L_MOVE,				"Move" },
		{ L_SIZE,				"Size" },

		{ 0, 0 } // End of array.
	};

	// See if it is a normal event.
	if (event.rawCode != 0xFFFF)
		return (UIW_WINDOW::Event(event));

	// Check for new keyboard event.
	UI_EVENT *tEvent;
	tEvent = (UI_EVENT *)event.data;
#ifdef _WINDOWS
	if (tEvent->type == E_MSWINDOWS)
	{
		MSG msg = event.message;
		char string[32];
		if (wMsg.message != msg.message)
		{
			sprintf(string, "%04x ", msg.message);
			windowsMessage[0]->Information(SET_TEXT, string);
		}
		if (wMsg.wParam != msg.wParam)
		{
			sprintf(string, "%04x ", msg.wParam);
			windowsMessage[1]->Information(SET_TEXT, string);
		}
		if (wMsg.lParam != msg.lParam)
		{
			sprintf(string, "%08x ", msg.lParam);
			windowsMessage[2]->Information(SET_TEXT, string);
		}
		if (wMsg.pt.x != msg.pt.x)
		{
			sprintf(string, "%d ", msg.pt.x);
			windowsMessage[3]->Information(SET_TEXT, string);
		}
		if (wMsg.pt.y != msg.pt.y)
		{
			sprintf(string, "%d ", msg.pt.y);
			windowsMessage[4]->Information(SET_TEXT, string);
		}
		wMsg = msg;
	}
#else
	if (tEvent->type == E_KEY)
	{
		char string[32];
		if (kEvent.rawCode != tEvent->rawCode)
		{
			sprintf(string, "%04x ", tEvent->rawCode);
			keyboard[0]->Information(SET_TEXT, string);
		}
		if (kEvent.key.shiftState != tEvent->key.shiftState)
		{
			sprintf(string, "%02x ", tEvent->key.shiftState);
			keyboard[1]->Information(SET_TEXT, string);
		}
		if (kEvent.key.value != tEvent->key.value)
		{
			sprintf(string, "%c ", tEvent->key.value);
			keyboard[2]->Information(SET_TEXT, string);
		}
		kEvent = *tEvent;
	}

	// Check for new mouse event.
	else if (tEvent->type == E_MOUSE)
	{
		char string[32];
		if (mEvent.rawCode != tEvent->rawCode)
		{
			sprintf(string, "%04x ", tEvent->rawCode);
			mouse[0]->Information(SET_TEXT, string);
		}
		if (mEvent.position.column != tEvent->position.column)
		{
			sprintf(string, "%03d ", tEvent->position.column);
			mouse[1]->Information(SET_TEXT, string);
		}
		if (mEvent.position.line != tEvent->position.line)
		{
			sprintf(string, "%03d ", tEvent->position.line);
			mouse[2]->Information(SET_TEXT, string);
		}
		mEvent = *tEvent;
	}
#endif

	// Check for new logical event.
	if (sEvent.type != event.type)
	{
		char *name = "<Unknown> ";
		for (int i = 0; eventTable[i].type; i++)
			if (event.type == eventTable[i].type)
			{
				name = eventTable[i].name;
				break;
			}
		system->Information(SET_TEXT, name);
		sEvent = event;
	}

	// Return the logical event.
	return (event.type);
}
