# ZINCAPP tutorial makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak zincapp.exe      (makes the zincapp tutorial program)
#    make -fzortech.mak wzincapp.exe     (makes the Windows zincapp program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: zincapp.exe wzincapp.exe


zincapp.exe: zincapp.obj control.obj display.obj window.obj event.obj help.obj support.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+zincapp.obj+control.obj+display.obj+window.obj+event.obj+help.obj+support.obj,$*, ,$(DOS_LIBS),NUL


wzincapp.exe: zincapp.obw control.obw display.obw window.obw event.obw help.obw support.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+zincapp.obw+control.obw+display.obw+window.obw+event.obw+help.obw+support.obw,$*, ,$(WIN_LIBS),wzincapp.def
	rc -k wzincapp.rc $*.exe
