//	CHECKBOX.CPP (CHECKBOX) - Checkbox example program.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include <ui_win.hpp>

#include "checkwin.hpp"

EVENT_TYPE DefaultSettings(UI_WINDOW_OBJECT *object,
	UI_EVENT &event, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	event.type = S_REDISPLAY;
	for (UI_WINDOW_OBJECT *window = object; window->parent;
		window = window->parent)
			;

	char stringID[30];
	strcpy(stringID, "BAUD_300");
	UIW_BUTTON *displayObject;
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "BAUD_1200");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "BAUD_2400");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "BAUD_9600");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus |= WOS_SELECTED | WOS_CURRENT;
	displayObject->Event(event);

	strcpy(stringID, "BAUD_19200");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "FULL_DUPLEX");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "XON_XOFF");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "SCROLL");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "DISPLAY_BAUD");
	UI_WINDOW_OBJECT *baudObject = (UI_WINDOW_OBJECT *)window->Information(GET_STRINGID_OBJECT, stringID);
	baudObject->Information(SET_TEXT, "9600 baud");
	displayObject->Event(event);

	strcpy(stringID, "DISPLAY_FULL_DUPLEX");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "DISPLAY_XON_XOFF");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	strcpy(stringID, "DISPLAY_SCROLL");
	displayObject = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	displayObject->woStatus &= ~WOS_SELECTED;
	displayObject->Event(event);

	return ccode;
}

EVENT_TYPE NewSettings(UI_WINDOW_OBJECT *object,
	UI_EVENT &event, EVENT_TYPE ccode)
{
	if (ccode != L_SELECT)
		return ccode;

	for (UI_WINDOW_OBJECT *window = object; window->parent;
		window = window->parent)
			;

	UI_WINDOW_OBJECT *displayObject;
	char stringID[30];
	strcpy(stringID, object->StringID());
	event.type = S_REDISPLAY;

	if (!strcmp(stringID, "FULL_DUPLEX") ||
		!strcmp(stringID, "XON_XOFF") ||
		!strcmp(stringID, "SCROLL"))
	{
		char string[30];
		strcpy(string, "DISPLAY_");
		strcat(string, stringID);
       	displayObject = (UI_WINDOW_OBJECT *)window->Information(GET_STRINGID_OBJECT, string);
       	if (FlagSet(object->woStatus, WOS_SELECTED))
           	displayObject->woStatus |= WOS_SELECTED;
       	else
           	displayObject->woStatus &= ~WOS_SELECTED;
		displayObject->Event(event);
	}
	else if (!strcmp(stringID, "BAUD_300") ||
		!strcmp(stringID, "BAUD_1200") ||
		!strcmp(stringID, "BAUD_2400") ||
		!strcmp(stringID, "BAUD_9600") ||
		!strcmp(stringID, "BAUD_19200"))
	{
       	char text[30];
       	char string[] = "DISPLAY_BAUD";

       	strcpy(text, (char *)object->Information(GET_TEXT, NULL));
       	displayObject = (UI_WINDOW_OBJECT *)window->Information(GET_STRINGID_OBJECT, string);
       	displayObject->Information(SET_TEXT, &text, ID_STRING);
		displayObject->Event(event);
	}

	return ccode;
}

UIW_WINDOW *CreateWindow()
{
	UIW_WINDOW *window = new UIW_WINDOW("CHECKWIN.DAT~SETUP_WINDOW");
   	if (FlagSet(window->woStatus, WOS_READ_ERROR))
       	return window;

	// Select the radio button to display the default baud rate.
	char stringID[30];
	strcpy(stringID, "BAUD_9600");
	UIW_BUTTON *button = (UIW_BUTTON *)window->Information(GET_STRINGID_OBJECT, stringID);
	button->woStatus |= WOS_SELECTED | WOS_CURRENT;

   	// Set the default display baud rate string.
   	strcpy(stringID, "DISPLAY_BAUD");
   	UI_WINDOW_OBJECT *object = (UI_WINDOW_OBJECT *)window->
       	Information(GET_STRINGID_OBJECT, stringID);
   	object->Information(SET_TEXT, "9600 baud");

   	return window;
}

#ifdef _WINDOWS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR, int nCmdShow)
{
	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);

#else

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

#endif

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

	*windowManager
		+ CreateWindow();

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

		// Send event information to the window manager.
		ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
