# COMBOBOX example makefile

# Uses Borland C++ 3.00 and Zinc Interface Library Version 3.00 

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB

#    make -fborland.mak combobox.exe      (makes the combobox example program)
#    make -fborland.mak wcombobo.exe     (makes the Windows combobox program)

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bcc
LINK=tlink
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
WIN_CPP_OPTS=-c -ml -O -WE -w
WIN_LINK_OPTS=/c /C /Twe /x

## Libraries:
DOS_OBJS=c0l
DOS_LIBS=zil graphics emu mathl cl
WIN_OBJS=c0wl
WIN_LIBS=zilw mathwl import cwl


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }


all: combobox.exe wcombobo.exe


combobox.exe: combobox.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+combobox.obj
$*, ,$(DOS_LIBS)
!


wcombobo.exe: combobox.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+combobox.obw
$*, ,$(WIN_LIBS),wcombobo.def
!
	rc wcombobo.rc $<
