//	Zinc Interface Library Designer - D_BITMAP.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include <ui_win.hpp>
#include "sketch.hpp"
#pragma hdrstop


#include <stdio.h>


COLOR UIW_BITMAP::leftColor = 0;
COLOR UIW_BITMAP::rightColor = 15;
COLOR UIW_BITMAP::screenColor = 7;

#if defined(_WINDOWS) | defined(_Windows)
extern void WindowsToZincBitmap(UI_DISPLAY *display, HBITMAP colorBitmap,
	HBITMAP monoBitmap, int *bitmapWidth, int *bitmapHeight,
	UCHAR **bitmapArray);
extern void ZincToWindowsBitmap(UI_DISPLAY *display, int bitmapWidth,
	int bitmapHeight, UCHAR *bitmapArray, UI_PALETTE *paletteArray,
	HBITMAP *colorBitmap, HBITMAP *monoBitmap);

// ----- Definition for the Windows UIW_BITMAP callback function -----
static int _bitmapOffset = -1;
static FARPROC _bitmapCallback = (FARPROC)DefWindowProc;
static FARPROC _bitmapJumpInstance = NULL;

long FAR PASCAL _export BitmapJumpProcedure(HWND hWnd, WORD wMsg,
	WORD wParam, LONG lParam)
{
	UI_WINDOW_OBJECT *object = (UI_WINDOW_OBJECT *)GetWindowLong(hWnd, _bitmapOffset);
	return (object->Event(UI_EVENT(E_MSWINDOWS, hWnd, wMsg, wParam, lParam)));
}


void *UIW_BITMAP::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	switch (request)
	{
	case FLOOD_COLOR:
		{
		COLOR newColor = (bitmapID == ID_LEFT_BITMAP) ?	leftColor : rightColor;
		if (newColor == 0xFF)
			newColor = screenColor;
		HDC hDC = GetDC(screenID);
		RECT region;
		GetClientRect(screenID, &region);
		HBRUSH fillBrush = CreateSolidBrush(display->MapColor(&display->colorMap[(int)newColor], TRUE));
		FillRect(hDC, &region, fillBrush);
		DeleteObject(fillBrush);
		ReleaseDC(screenID, hDC);
		}
		break;

	case GET_BITMAP_WIDTH:
		*(int *)data = bitmapWidth;
		break;

	case SET_BITMAP_WIDTH:
		bitmapWidth = *(int *)data;
		if (bitmapID == ID_VIEW_BITMAP)
			bitmapWidth += 16;
		relative.right = relative.left + bitmapWidth * ratioWidth - 1;
		if (FlagSet(woFlags, WOF_BORDER))
			relative.right += 2;
		true = relative;
		break;

	case GET_BITMAP_HEIGHT:
		*(int *)data = bitmapHeight;
		break;

	case SET_BITMAP_HEIGHT:
		bitmapHeight = *(int *)data;
		if (bitmapID == ID_VIEW_BITMAP)
			bitmapHeight += 16;
		relative.bottom = relative.top + bitmapHeight * ratioHeight - 1;
		if (FlagSet(woFlags, WOF_BORDER))
			relative.bottom += 2;
		true = relative;
		break;

	case GET_BITMAP_ARRAY:
 //		if (!bitmapArray)
			WindowsToZincBitmap(display, colorBitmap, monoBitmap,
				&bitmapWidth, &bitmapHeight, &bitmapArray);
		if (!data)
			return (bitmapArray);
		*(UCHAR **)data = bitmapArray;
		break;

	case SET_BITMAP_ARRAY:
		{
		if (bitmapID == ID_VIEW_BITMAP)
		{
			bitmapArray = new UCHAR[bitmapWidth * bitmapHeight];
			memset(bitmapArray, 0xFF, bitmapWidth * bitmapHeight);
			for (int x = 0; x < bitmapWidth - 16; x++)
			{
				for (int y = 0; y < bitmapHeight - 16; y++)
					bitmapArray[(y + 8) * bitmapWidth + x + 8] =
						((UCHAR *)data)[y * (bitmapWidth - 16) + x];
			}
		}
		else
			bitmapArray = (UCHAR *)data;
		if (colorBitmap)
			DeleteObject(colorBitmap);
		if (monoBitmap)
			DeleteObject(monoBitmap);

		UCHAR *tempArray = new UCHAR[bitmapWidth * bitmapHeight];
		for (int x = 0; x < bitmapWidth; x++)
		{
			for (int y = 0; y < bitmapHeight; y++)
			{
				int color = bitmapArray[y * bitmapWidth + x];
				if (color == 0xFF)
					color = (int)screenColor;
				tempArray[y * bitmapWidth + x] = color;
			}
		}
		ZincToWindowsBitmap(display, bitmapWidth, bitmapHeight,
			tempArray, NULL, &colorBitmap, &monoBitmap);
		delete tempArray;
		}
		break;


	default:
		data = UI_WINDOW_OBJECT::Information(request, data, objectID);
		break;
	}

	// Call the info function for the edit object.
//	if (editObject)
//		editObject->Information(request, data, objectID);

	// Return the information.
	return (data);
}
#else

void *UIW_BITMAP::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	switch (request)
	{
	case FLOOD_COLOR:
		{
		COLOR newColor = (bitmapID == ID_LEFT_BITMAP) ?	leftColor : rightColor;
		if (newColor == 0xFF)
			newColor = screenColor;
		UI_REGION region = true;
		++region.left;
		++region.top;
		--region.right;
		--region.bottom;
		display->Rectangle(screenID, region, &_colorMap[newColor], 0, TRUE);
		}
		break;

	case GET_BITMAP_WIDTH:
		*(int *)data = bitmapWidth;
		break;

	case SET_BITMAP_WIDTH:
		bitmapWidth = *(int *)data;
		if (bitmapID == ID_VIEW_BITMAP)
			bitmapWidth += 16;
		relative.right = relative.left + bitmapWidth * ratioWidth - 1;
		if (FlagSet(woFlags, WOF_BORDER))
			relative.right += 2;
		true = relative;
		break;

	case GET_BITMAP_HEIGHT:
		*(int *)data = bitmapHeight;
		break;

	case SET_BITMAP_HEIGHT:
		bitmapHeight = *(int *)data;
		if (bitmapID == ID_VIEW_BITMAP)
			bitmapHeight += 16;
		relative.bottom = relative.top + bitmapHeight * ratioHeight - 1;
		if (FlagSet(woFlags, WOF_BORDER))
			relative.bottom += 2;
		true = relative;
		break;

	case GET_BITMAP_ARRAY:
		if (!data)
			return (bitmapArray);
		*(UCHAR **)data = bitmapArray;
		break;

	case SET_BITMAP_ARRAY:
		if (bitmapID == ID_VIEW_BITMAP)
		{
			bitmapArray = new UCHAR[bitmapWidth * bitmapHeight];
			memset(bitmapArray, 0xFF, bitmapWidth * bitmapHeight);
			for (int x = 0; x < bitmapWidth - 16; x++)
			{
				for (int y = 0; y < bitmapHeight - 16; y++)
					bitmapArray[(y + 8) * bitmapWidth + x + 8] =
						((UCHAR *)data)[y * (bitmapWidth - 16) + x];
			}
		}
		else
			bitmapArray = (UCHAR *)data;
		break;

	default:
		data = UI_WINDOW_OBJECT::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}
#endif

void UIW_BITMAP::Pixel(int column, int line, UCHAR color)
{
	if (bitmapID == ID_EDIT_BITMAP)
	{
		viewObject->Pixel(column, line, color);
	}
	else
	{
		column += 8;
		line += 8;
	}
	bitmapArray[line * bitmapWidth + column] = color;
	if (color == 0xFF)
		color = screenColor;
#ifdef _WINDOWS
	COLOR tempColor = display->MapColor(&display->colorMap[color], TRUE);
	HDC hDC = GetDC(screenID);
	HDC hMemDC = CreateCompatibleDC(hDC);
	SelectObject(hMemDC, colorBitmap);
	SetPixel(hMemDC, column, line, tempColor);
	DeleteDC(hMemDC);
	RECT region;
	region.left = column * ratioWidth;
	region.top = line * ratioHeight;
	region.right = region.left + ratioWidth;
	region.bottom = region.top + ratioHeight;
	HBRUSH fillBrush = CreateSolidBrush(tempColor);
	FillRect(hDC, &region, fillBrush);
	DeleteObject(fillBrush);
	ReleaseDC(screenID, hDC);
#else
	UI_REGION region;
	region.left = true.left + column * ratioWidth + 1;
	region.top = true.top + line * ratioHeight + 1;
	region.right = region.left + ratioWidth - 1;
	region.bottom = region.top + ratioHeight - 1;
	display->Rectangle(screenID, region, &display->colorMap[color], 0, TRUE);
#endif
}

EVENT_TYPE UIW_BITMAP::DrawItem(const UI_EVENT &event)
{
#ifdef _WINDOWS
	DRAWITEMSTRUCT *draw = (DRAWITEMSTRUCT *)event.message.lParam;
	if (bitmapArray)
	{
		HDC hMemDC = CreateCompatibleDC(draw->hDC);
		SelectObject(hMemDC, colorBitmap);
		StretchBlt(draw->hDC, 0, 0, bitmapWidth * ratioWidth,
			bitmapHeight * ratioHeight, hMemDC, 0, 0, bitmapWidth,
			bitmapHeight, SRCCOPY);
		DeleteDC(hMemDC);
	}
	else
	{
		COLOR drawColor;
		if (bitmapID == ID_SCREEN_BITMAP)
			drawColor = screenColor;
		else
			drawColor = (bitmapID == ID_LEFT_BITMAP) ? leftColor : rightColor;
		if (drawColor == 0xFF)
			drawColor = screenColor;
		HBRUSH fillBrush = CreateSolidBrush(display->MapColor(&display->colorMap[(int)drawColor], TRUE));
		FillRect(draw->hDC, &draw->rcItem, fillBrush);
		DeleteObject(fillBrush);
	}
#else
	UI_REGION region = true;
	DrawBorder(screenID, region, FALSE, event.type);
	if (bitmapID == ID_VIEW_BITMAP)
	{
		UCHAR *tempArray = new UCHAR[bitmapWidth * bitmapHeight];
		for (int i = 0; i < bitmapWidth * bitmapHeight; i++)
		{
			tempArray[i] = bitmapArray[i];
			if (tempArray[i] == 0xFF)
				tempArray[i] = screenColor;
		}
		display->Bitmap(screenID, true.left + 1, true.top + 1, bitmapWidth,
			bitmapHeight, tempArray);
		delete tempArray;
	}
	else if (bitmapArray)
	{
		display->VirtualGet(screenID, true);
		int k = 0;
		region.top = true.top + 1;
		for (int i = 0; i < bitmapHeight; i++)
		{
			region.bottom = region.top + ratioHeight - 1;
			region.left = true.left + 1;
			for (int j = 0; j < bitmapWidth; j++, k++)
			{
				region.right = region.left + ratioWidth - 1;
				if (region.Overlap(event.region))
				{
					int color = bitmapArray[k];
					if (color == 0xFF)
						color = screenColor;
					display->Rectangle(screenID, region,
						&display->colorMap[color], 0, TRUE);
				}
				region.left += ratioWidth;
			}
			region.top += ratioHeight;
		}
		display->VirtualPut(screenID);
	}
	else
	{
		COLOR drawColor;
		if (bitmapID == ID_SCREEN_BITMAP)
			drawColor = 0xFF;
		else
			drawColor = (bitmapID == ID_LEFT_BITMAP) ? leftColor : rightColor;
		if (drawColor == 0xFF)
			drawColor = screenColor;
		display->Rectangle(screenID, region, &display->colorMap[drawColor], 0, TRUE);
	}
#endif
	return (TRUE);
}



EVENT_TYPE UIW_BITMAP::Event(const UI_EVENT &_event)
{
	UI_EVENT event;
	event = _event;

#ifdef _WINDOWS
	if (event.type == E_MSWINDOWS)
	{
		if (_event.message.hwnd != screenID)
			return S_UNKNOWN;
		WORD message = _event.message.message;
		WORD wParam = _event.message.wParam;
		if (message == WM_LBUTTONDOWN || message == WM_RBUTTONDOWN ||
			(message == WM_MOUSEMOVE && (wParam == MK_LBUTTON || wParam == MK_RBUTTON)))
		{
			event.type = E_MOUSE;
			if (message == WM_LBUTTONDOWN || wParam == MK_LBUTTON)
				event.rawCode = M_LEFT;
			else if (message == WM_RBUTTONDOWN || wParam == MK_RBUTTON)
				event.rawCode = M_RIGHT;
			event.position.column += true.left;
			event.position.line += true.top;
		}
		else if (message == WM_PAINT)
		{
			PAINTSTRUCT ps;
			DRAWITEMSTRUCT draw;
			UI_EVENT tEvent(E_MSWINDOWS);
			draw.hDC = BeginPaint(screenID, &ps);
			draw.rcItem.left = draw.rcItem.top = 0;
			draw.rcItem.right = relative.right - relative.left;
			draw.rcItem.bottom = relative.bottom - relative.top;
			draw.CtlType = ODT_BUTTON;
			draw.itemAction = ODA_DRAWENTIRE;
			tEvent.message.lParam = (LONG)&draw;
			DrawItem(tEvent);
			EndPaint(screenID, &ps);
		}
	}

	#endif

	// Switch on the event type.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
#ifdef _WINDOWS
		if (!_bitmapJumpInstance)
			_bitmapJumpInstance = (FARPROC)BitmapJumpProcedure;
		UI_WINDOW_OBJECT::Event(event);

		// Read in the bitmap if so specified.
		if (!colorBitmap && bitmapName)
		{
			char tempName[32];
			strcpy(tempName, "_");
			strcat(tempName, bitmapName);
			colorBitmap = LoadBitmap(display->hInstance, bitmapName);
			monoBitmap = LoadBitmap(display->hInstance, tempName);
			dwStyle |= BS_OWNERDRAW;
			if (!bitmapArray)
			{
				WindowsToZincBitmap(display, colorBitmap, monoBitmap,
					&bitmapWidth, &bitmapHeight, &bitmapArray);
			}
		}
		if (colorBitmap)
		{
			BITMAP bm;
			GetObject(colorBitmap, sizeof(BITMAP), (LPSTR)&bm);
			bitmapHeight = bm.bmHeight;
			bitmapWidth = bm.bmWidth;
			if (!bitmapArray)
			{
				WindowsToZincBitmap(display, colorBitmap, monoBitmap,
					&bitmapWidth, &bitmapHeight, &bitmapArray);
			}
		}
#else
		UI_WINDOW_OBJECT::Event(event);

		// Read in the bitmap if so specified.
		if (bitmapName && !bitmapArray)
		{
			defaultStorage->ChDir("~UI_BITMAP");
			UI_STORAGE_OBJECT sObject(*defaultStorage, bitmapName, ID_BITMAP_IMAGE, UIS_READ);
			if (!sObject.objectError)
			{
				short _value; sObject.Load(&_value); bitmapWidth = _value;
				sObject.Load(&_value); bitmapHeight = _value;
				bitmapArray = new UCHAR[bitmapWidth * bitmapHeight];
				sObject.Load(bitmapArray, sizeof(UCHAR), bitmapWidth * bitmapHeight);
			}
		}
#endif
		relative.right = relative.left + bitmapWidth * ratioWidth + 1;
		relative.bottom = relative.top + bitmapHeight * ratioHeight + 1;
		true = relative;
		break;

#ifdef _WINDOWS
	case S_CREATE:
		RegisterObject("UIW_BITMAP", NULL, &_bitmapOffset,
			&_bitmapJumpInstance, &_bitmapCallback, NULL);
		break;
#endif

	case S_REDISPLAY:
//		relative.right = relative.left + bitmapWidth * ratioWidth + 1;
//		relative.bottom = relative.top + bitmapHeight * ratioHeight + 1;
//		true = relative;
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;

#ifndef _WINDOWS
	case S_CURRENT:
	case S_NON_CURRENT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		UI_WINDOW_OBJECT::Event(event);
		if (FlagSet(woStatus, WOS_REDISPLAY))
		{
			DrawItem(event);
			woStatus &= ~WOS_REDISPLAY;
		}
		break;
#endif

	case IMAGE_PENCIL:
/* START BLOCK COMMENT
**		case IMAGE_BRUSH:
**		case IMAGE_LINE:
**		case IMAGE_RECTANGLE:
**		case IMAGE_FILL_RECTANGLE:
**		case IMAGE_ELLIPSE:
**		case IMAGE_FILL_ELLIPSE:
**		case IMAGE_FILL:
END BLOCK COMMENT */
		drawStyle = event.type;
		break;

	case E_MOUSE:
		if (FlagSet(event.rawCode, M_LEFT | M_RIGHT) && true.Overlap(event.position))
		{
			int column = (event.position.column - true.left - 1) / ratioWidth;
			int line = (event.position.line - true.top - 1) / ratioHeight;
			if (column < 0)
				column = 0;
			else if (column > bitmapWidth - 1)
				column = bitmapWidth - 1;
			if (line < 0)
				line = 0;
			else if (line > bitmapHeight - 1)
				line = bitmapHeight - 1;
			if (bitmapID == ID_COLOR_BITMAP || bitmapID == ID_SCREEN_BITMAP)
			{
				UCHAR color;
				if (bitmapID == ID_COLOR_BITMAP)
					color = bitmapArray[2 * line + column];
				else
					color = 0xFF;

				if (FlagsSet(event.rawCode, M_LEFT))
				{
					leftColor = color;
					leftObject->Information(FLOOD_COLOR, NULL);
				}
				else
				{
					rightColor = color;
					rightObject->Information(FLOOD_COLOR, NULL);
				}
			}
			else if (bitmapID == ID_EDIT_BITMAP)
			{
				COLOR color = (FlagsSet(event.rawCode, M_LEFT)) ? leftColor : rightColor;
				if (drawStyle == IMAGE_PENCIL)
					Pixel(column, line, color);
/* START BLOCK COMMENT
**					else if (drawStyle == IMAGE_FILL)
**					{
**						if (bitmapArray[line * bitmapWidth + column] != color)
**							Fill(column, line, bitmapArray[line * bitmapWidth + column], color);
**					}
**					else if (drawStyle == IMAGE_BRUSH)
**					{
**						Pixel(column, line, color);
**						if (column > 0)
**							Pixel(column - 1, line, color);
**						if (column > 0 && line > 0)
**							Pixel(column - 1, line - 1, color);
**						if (line > 0)
**							Pixel(column, line - 1, color);
**						if (column < bitmapWidth - 1 && line > 0)
**							Pixel(column + 1, line - 1, color);
**						if (column < bitmapWidth - 1)
**							Pixel(column + 1, line, color);
**						if (column < bitmapWidth - 1 && line < bitmapHeight - 1)
**							Pixel(column + 1, line + 1, color);
**						if (line < bitmapHeight - 1)
**							Pixel(column, line + 1, color);
**						if (column > 0 && line < bitmapHeight - 1)
**							Pixel(column - 1, line + 1, color);
**					}
**					else if (FlagSet(event.rawCode, M_LEFT_CHANGE | M_RIGHT_CHANGE))
**						GetImageRegion(event.position.column, event.position.line, color);
END BLOCK COMMENT */
			}
			else if (bitmapID == ID_VIEW_BITMAP)
			{
				int newColor = (FlagsSet(event.rawCode, M_LEFT)) ? (int)leftColor : (int)rightColor;
				if (newColor == 0xFF)
					newColor = (int)screenColor;
				if (newColor != screenColor)
				{
					screenColor = newColor;
#ifdef _WINDOWS
					editObject->Information(SET_BITMAP_ARRAY, editObject->bitmapArray);
					Information(SET_BITMAP_ARRAY, editObject->bitmapArray);
#endif
					screenObject->Event(UI_EVENT(S_REDISPLAY));
					editObject->Event(UI_EVENT(S_REDISPLAY));
					Event(UI_EVENT(S_REDISPLAY));
				}
			}
		}

	default:
  		ccode = UI_WINDOW_OBJECT::Event(event);

	}

	// Return the control code.
	return (ccode);
}

//void UIW_BITMAP::Fill(int column, int line, UCHAR oldColor, UCHAR newColor)
//{
/* START BLOCK COMMENT
**		char *stack = _errorMemory;
**		int stackPtr = 0;
**		do
**		{
**			while (stackPtr > 1)
**			{
**				line = readStack[--*readPtr];
**				column = readStack[--*readPtr];
**				if (*writePtr < 1024 - 8)
**				{
**					if (column > 0 && bitmapArray[line * bitmapWidth + column - 1] == oldColor)
**					{
**						Pixel(column - 1, line, newColor);
**						writeStack[(*writePtr)++] = column - 1;
**						writeStack[(*writePtr)++] = line;
**					}
**					if (line > 0 && bitmapArray[(line - 1) * bitmapWidth + column] == oldColor)
**					{
**						Pixel(column, line - 1, newColor);
**						writeStack[(*writePtr)++] = column;
**						writeStack[(*writePtr)++] = line - 1;
**					}
**					if (column < bitmapWidth - 1 && bitmapArray[line * bitmapWidth + column + 1] == oldColor)
**					{
**						Pixel(column + 1, line, newColor);
**						writeStack[(*writePtr)++] = column + 1;
**						writeStack[(*writePtr)++] = line;
**					}
**					if (line < bitmapHeight - 1 && bitmapArray[(line + 1) * bitmapWidth + column] == oldColor)
**					{
**						Pixel(column, line - 1, newColor);
**						writeStack[(*writePtr)++] = column;
**						writeStack[(*writePtr)++] = line + 1;
**					}
**				}
**			}
**			int *temp = readStack;
**			readStack = writeStack;
**			writeStack = temp;
**			temp = readPtr;
**			readPtr = writePtr;
**			writePtr = temp;
**		} while (*readPtr > 1);
END BLOCK COMMENT */
//}

//void UIW_BITMAP::GetImageRegion(int x, int y, UCHAR color)
//{
/* START BLOCK COMMENT
**		// Initialize the modify variables.
**		UI_REGION region;
**		UI_REGION newRegion;
**		newRegion.left = newRegion.right = x;
**		newRegion.top = newRegion.bottom = y;
**		UI_POSITION origin;
**		origin.column = x;
**		origin.line = y;
**	
**		EVENT_TYPE ccode = S_UNKNOWN;
**		display->Rectangle(ID_DIRECT, newRegion, display->xorPalette, 1, FALSE, TRUE);
**		do
**		{
**			UI_EVENT event;
**			UI_REGION oldRegion;
**			eventManager->Get(event);
**			ccode = LogicalEvent(event);
**			switch (ccode)
**			{
**			case L_CONTINUE_SELECT:
**				if (event.position.column < true.left + 1)
**					event.position.column = true.left + 1;
**				else if (event.position.column > true.right - 1)
**					event.position.column = true.right - 1;
**				if (event.position.line < true.top + 1)
**					event.position.line = true.top + 1;
**				else if (event.position.line > true.bottom - 1)
**					event.position.line = true.bottom - 1;
**				oldRegion = newRegion;
**				newRegion.left = Min(origin.column, event.position.column);
**				newRegion.top = Min(origin.line, event.position.line);
**				newRegion.right = Max(origin.column, event.position.column);
**				newRegion.bottom = Max(origin.line, event.position.line);
**				// Update the new region.
**				if (oldRegion != newRegion)
**					display->RectangleXORDiff(oldRegion, newRegion);
**				break;
**			}
**		} while (ccode != L_END_SELECT && ccode != L_SELECT);
**	
**		// Restore the region.
**		display->Rectangle(ID_DIRECT, newRegion, display->xorPalette, 1, FALSE, TRUE);
**		region.left = (newRegion.left - true.left - 1) / ratioWidth;
**		region.right = (newRegion.right - true.left - 1) / ratioWidth;
**		region.top = (newRegion.top - true.top - 1) / ratioHeight;
**		region.bottom = (newRegion.bottom - true.top - 1) / ratioHeight;
**		UI_POSITION tPosition;
**		long a = (region.right - region.left) / 2;
**		long b = (region.bottom - region.top) / 2;
**		long centerX = region.left + a;
**		long centerY = region.top + b;
**		int slopeX = region.right - region.left;
**		int slopeY = region.bottom - region.top;
**	
**		for (int xPos = 0; xPos < bitmapWidth; ++xPos)
**		{
**			for (int yPos = 0; yPos < bitmapWidth; ++yPos)
**			{
**			 	int drawIt = FALSE;
**				switch (drawStyle)
**				{
**				case IMAGE_RECTANGLE:
**					if ((yPos == region.top && xPos >= region.left && xPos <= region.right) ||
**						(yPos == region.bottom && xPos >= region.left && xPos <= region.right) ||
**						(xPos == region.left && yPos >= region.top && yPos <= region.bottom) ||
**						(xPos == region.right && yPos >= region.top && yPos <= region.bottom))
**						drawIt = TRUE;
**					break;
**	
**				case IMAGE_FILL_RECTANGLE:
**					{
**					tPosition.column = xPos;
**					tPosition.line = yPos;
**					if (region.Overlap(tPosition))
**						drawIt = TRUE;
**					}
**					break;
**	
**				case IMAGE_ELLIPSE:
**					{
**						long tempX = xPos - centerX;
**						if (tempX < 0)
**							tempX = -tempX;
**						long tempY = yPos - centerY;
**						if (tempY < 0)
**							tempY = -tempY;
**						long maxError = Min(((tempX + 1) * (tempX + 1) - tempX * tempX) * b * b,
**							((tempY + 1) * (tempY + 1) - tempY * tempY) * a * a);
**						long test = tempX * tempX * b * b + tempY * tempY * a * a;
**						if (test >= a * a * b * b && test < a * a * b * b + maxError)
**							drawIt = TRUE;
**					}
**					break;
**	
**				case IMAGE_FILL_ELLIPSE:
**					{
**						long tempX = xPos - centerX;
**						if (tempX < 0)
**							tempX = -tempX;
**						long tempY = yPos - centerY;
**						if (tempY < 0)
**							tempY = -tempY;
**						long maxError = Max(((tempX + 1) * (tempX + 1) - tempX * tempX) * b * b,
**							((tempY + 1) * (tempY + 1) - tempY * tempY) * a * a);
**						if (tempX * tempX * b * b + tempY * tempY * a * a < a * a * b * b + maxError)
**							drawIt = TRUE;
**					}
**					break;
**	
**				case IMAGE_LINE:
**					if ((region.left == x && region.top == y) || (region.right == x && region.bottom == y))
**					{
**						int tempX = xPos - region.left;
**						int tempY = yPos - region.top;
**						if (tempX * slopeY >= tempY * slopeX - 2 && tempX * slopeY <= tempY * slopeX + 2)
**							drawIt = TRUE;
**					}
**					else
**					{
**						int tempX = region.right - xPos;
**						int tempY = region.bottom - yPos;
**						if (tempX * slopeY >= tempY * slopeX - 2 && tempX * slopeY <= tempY * slopeX + 2)
**							drawIt = TRUE;
**					}
**					break;
**				}
**				if (drawIt)
**					Pixel(xPos, yPos, color);
**			}
**		}
END BLOCK COMMENT */
//}

UIW_BITMAP::UIW_BITMAP(int left, int top, char *_bitmapName, BITMAP_ID _bitmapID,
	int _ratioWidth, int _ratioHeight) :
	UI_WINDOW_OBJECT(left, top, 0, 0, WOF_BORDER, WOAF_NO_FLAGS),
	ratioWidth(_ratioWidth), ratioHeight(_ratioHeight),	bitmapName(NULL),
	bitmapArray(NULL), bitmapID(_bitmapID), drawStyle(IMAGE_PENCIL),
	bitmapWidth(1), bitmapHeight(1)

{
	bitmapName = ui_strdup(_bitmapName);
#ifdef _WINDOWS
	colorBitmap = monoBitmap = 0;
#endif
}

UIW_BITMAP::~UIW_BITMAP(void)
{
/* START BLOCK COMMENT
**		if (bitmapName)
**			delete bitmapName;
**	#ifdef _WINDOWS
**		if (colorBitmap)
**			DeleteObject(colorBitmap);
**		if (monoBitmap)
**			DeleteObject(monoBitmap);
**	#endif
**		if (bitmapID == ID_COLOR_BITMAP)
**			delete bitmapArray;
END BLOCK COMMENT */
}

