# ERROR example makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak error.exe      (makes the error example program)
#    make -fzortech.mak werror.exe     (makes the Windows error program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: error.exe werror.exe


error.exe: error.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+error.obj,$*, ,$(DOS_LIBS),NUL


werror.exe: error.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+error.obw,$*, ,$(WIN_LIBS),werror.def
	rc -k werror.rc $*.exe
