# FILEEDIT example makefile

# Uses Borland C++ 3.00 and Zinc Interface Library Version 3.00 

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB

#    make -fborland.mak fileedit.exe      (makes the fileedit example program)
#    make -fborland.mak wfileedi.exe     (makes the Windows fileedit program)

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bcc
LINK=tlink
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
WIN_CPP_OPTS=-c -ml -O -WE -w
WIN_LINK_OPTS=/c /C /Twe /x

## Libraries:
DOS_OBJS=c0l
DOS_LIBS=zil graphics emu mathl cl
WIN_OBJS=c0wl
WIN_LIBS=zilw mathwl import cwl


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }


all: fileedit.exe wfileedi.exe


fileedit.exe: fileedit.obj dialog.obj direct.obj dir_win.obj file.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+fileedit.obj+dialog.obj+direct.obj+dir_win.obj+file.obj
$*, ,$(DOS_LIBS)
!


wfileedi.exe: fileedit.obw dialog.obw direct.obw dir_win.obw file.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+fileedit.obw+dialog.obw+direct.obw+dir_win.obw+file.obw
$*, ,$(WIN_LIBS),wfileedi.def
!
	rc wfileedi.rc $<
