# PERIODIC example makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak periodic.exe      (makes the periodic example program)
#    make -fzortech.mak wperiodi.exe     (makes the Windows periodic program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: periodic.exe wperiodi.exe


periodic.exe: periodic.obj per_win.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+periodic.obj+per_win.obj,$*, ,$(DOS_LIBS),NUL


wperiodi.exe: periodic.obw per_win.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+periodic.obw+per_win.obw,$*, ,$(WIN_LIBS),wperiodi.def
	rc -k wperiodi.rc $*.exe
