//	SOUND.HPP (PIANO) - Sample electronic piano sound class.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#define TOO_LOW -1
#define CHANGED_PITCH 1
#define SOUND_ON 0

#define LowByte(value) 0x000000FF & value
#define HighByte(value) 0x000000FF & (value >> 8)

#define MAX_CLOCK 2147483647L
#define CLOCK_ERROR -1
#define CLOCK_OKAY 0

class EXPORT UI_SOUND
{
public:
	UI_SOUND(unsigned short _defaultHZ = 180, unsigned short _defaultDuration = 100) :
			defaultHZ(_defaultHZ), defaultDuration(_defaultDuration)
			{}

	void Beep(unsigned short hZ = 0, unsigned short duration = 0);
	int Pause(unsigned duration = 0);

protected:
	int SoundOn(unsigned short hZ = 0);
	void SoundOff();

private:
	// hZ is in cycles per second.
	unsigned short defaultHZ;
	// duration is in milliseconds.
	unsigned short defaultDuration;
};
