# SPY example makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak spy.exe      (makes the spy example program)
#    make -fzortech.mak wspy.exe     (makes the Windows spy program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: spy.exe wspy.exe


spy.exe: spy.obj tty.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+spy.obj+tty.obj,$*, ,$(DOS_LIBS),NUL


wspy.exe: spy.obw tty.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+spy.obw+tty.obw,$*, ,$(WIN_LIBS),wspy.def
	rc -k wspy.rc $*.exe
