# VALIDATE example makefile

# Uses Zortech C++ 3.00r4 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_Z30;C:\ZTC\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\ZTC\INCLUDE

#    make -fzortech.mak validate.exe      (makes the validate example program)
#    make -fzortech.mak wvalidat.exe     (makes the Windows validate program)

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blink
DOS_CPP_OPTS=-c -ml -a1 -br
DOS_LINK_OPTS=/NOI
WIN_CPP_OPTS=-c -ml -a1 -br -W2
WIN_LINK_OPTS=/NOI

## Libraries
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw $<


all: validate.exe wvalidat.exe


validate.exe: validate.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+validate.obj,$*, ,$(DOS_LIBS),NUL


wvalidat.exe: validate.obw
	$(LINK) $(WIN_LINK_OPTS) $(WIN_OBJS)+validate.obw,$*, ,$(WIN_LIBS),wvalidat.def
	rc -k wvalidat.rc $*.exe
