//	Zinc Interface Library - BIGNUM1.HPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include "ui_gen.hpp"
#pragma hdrstop

/*--------------------------------------------------------------------------*/
/* Support for mixed mode (UI_BIGNUM op double) operations */
void UI_BIGNUM::Export(rbignum *value)
{
	rbignum r;
	char tmp[NUMBER_WHOLE+NUMBER_DECIMAL+4];

	Export(tmp, NMF_DECIMAL(NUMBER_DECIMAL));
	(void) sscanf(tmp, "%f", &r);
	*value = r;
}

void UI_BIGNUM::rtob(rbignum value)
{
	int i;
	char tmp[NUMBER_WHOLE+NUMBER_DECIMAL+4];

	zero();
	if (value < 0) {
		sign = 1;
		value = -value;
	}
	(void) sprintf(tmp, "%-.*f", NUMBER_DECIMAL, value);
	if (!UI_INTERNATIONAL::initialized)
		UI_INTERNATIONAL::Initialize();
	for (i=0; tmp[i]; i++)
		if (tmp[i] == '.')
			tmp[i] = UI_INTERNATIONAL::monDecimalSeparator[0];
	Import(tmp);
}

NMI_RESULT UI_BIGNUM::Import(rbignum value)
{
	this->rtob(value);
	return NMI_OK;
}
