## Zinc Interface Library version 3.00 makefile
## DESIGN.EXE, WDESIGN.EXE and GENHELP.EXE
## COPYRIGHT (C) 1990-1992.  All Rights Reserved.
## Zinc Software Incorporated.  Pleasant Grove, Utah  USA

## Uses Microsoft C++ 7.00

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=cl
LINK=link
LIBRARIAN=lib
DOS_CPP_OPTS=-c -AL -BATCH -Gs -Fpzil.pch -nologo
DOS_LINK_OPTS=/NOD /NOI /BATCH /SEGMENTS:256
DOS_LIB_OPTS=/NOI
WIN_CPP_OPTS=-c -AL -BATCH -Gsw -Fpzilw.pch -nologo -DWINVER=0x0300
WIN_LINK_OPTS=/NOD /NOI /BATCH /SEGMENTS:256
WIN_LIB_OPTS=/NOI
WINDLL_CPP_OPTS=-c -AL -BATCH -Gsw -Fpzilwd.pch -nologo -DWINVER=0x0300 -D__DLL__
WINDLL_LINK_OPTS=/NOD /NOI /BATCH /SEGMENTS:256 /Ld
WINDLL_LIB_OPTS=/NOI
INCLUDE_DIR=.

## Libraries:
DOS_OBJS=
DOS_LIBS=zil llibce graphics oldnames
WIN_OBJS=
WIN_LIBS=zilw libw llibcew oldnames
WINDLL_OBJS=
WINDLL_LIBS=libw llibcew oldnames


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) -Yu $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -Yu -Fo$*.obw $<

.cpp.obd:
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -Yu -Fo$*.obd $<

.rc.res:
	rc -r $<


bin: design.exe wdesign.exe genhelp.exe


genhelp.exe: zil.pch genhelp.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+$*, $*, , $(DOS_LIBS), NUL


design.exe: zil.pch d_design.obj \
	d_bitmap.obj d_combo.obj d_config.obj d_ctrl.obj d_dialog.obj \
	d_doserr.obj d_file.obj d_frame.obj d_help.obj d_help1.obj \
	d_hlpbar.obj d_hlpmsg.obj d_image.obj d_image1.obj d_jump.obj \
	d_list.obj d_memerr.obj d_resrc.obj d_util.obj
	$(LINK) $(DOS_LINK_OPTS) /STACK:8192@<<zil.rsp
$(DOS_OBJS)+d_design.obj+
d_bitmap.obj+d_combo.obj+d_config.obj+d_ctrl.obj+d_dialog.obj+
d_doserr.obj+d_file.obj+d_frame.obj+d_help.obj+d_help1.obj+
d_hlpbar.obj+d_hlpmsg.obj+d_image.obj+d_image1.obj+d_jump.obj+
d_list.obj+d_memerr.obj+d_resrc.obj+d_util.obj
$*, , $(DOS_LIBS)
NUL
<<


wdesign.exe: zilw.pch wdesign.res d_design.obw \
	d_bitmap.obw d_combo.obw d_config.obw d_ctrl.obw d_dialog.obw \
	d_doserr.obw d_file.obw d_frame.obw d_help.obw d_help1.obw \
	d_hlpbar.obw d_hlpmsg.obw d_image.obw d_image1.obw d_jump.obw \
	d_list.obw d_memerr.obw d_resrc.obw d_util.obw
	$(LINK) $(WIN_LINK_OPTS) /STACK:8192@<<zil.rsp
$(WIN_OBJS)+d_design.obw+
d_bitmap.obw+d_combo.obw+d_config.obw+d_ctrl.obw+d_dialog.obw+
d_doserr.obw+d_file.obw+d_frame.obw+d_help.obw+d_help1.obw+
d_hlpbar.obw+d_hlpmsg.obw+d_image.obw+d_image1.obw+d_jump.obw+
d_list.obw+d_memerr.obw+d_resrc.obw+d_util.obw
$*, , $(WIN_LIBS)
$*.def
<<
	rc -30 -k $*.res $*.exe
	@del *.pch


## Build the pre-compiled header files:
zil.pch: ui_dsn.hpp
	@echo @<<hdrfile.cpp
#define OEMRESOURCE
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <graph.h>
#include <io.h>
#include <limits.h>
#include <locale.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#define USE_RAW_KEYS
#include "ui_dsn.hpp"
<<
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) -Yc hdrfile.cpp
	@del hdrfile.obj


## Build the pre-compiled header files:
zilw.pch: ui_dsn.hpp
	@echo @<<hdrfile.cpp
#define OEMRESOURCE
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <graph.h>
#include <io.h>
#include <limits.h>
#include <locale.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#define USE_RAW_KEYS
#include "ui_dsn.hpp"
<<
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -Yc hdrfile.cpp
	@del hdrfile.obw


## Build the pre-compiled header files:
zilwd.pch: ui_dsn.hpp
	@echo @<<hdrfile.cpp
#define OEMRESOURCE
#include <conio.h>
#include <ctype.h>
#include <dos.h>
#include <direct.h>
#include <errno.h>
#include <fcntl.h>
#include <graph.h>
#include <io.h>
#include <limits.h>
#include <locale.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <time.h>
#define USE_RAW_KEYS
#include "ui_dsn.hpp"
<<
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -Yc hdrfile.cpp
	@del hdrfile.obd
