## Zinc Interface Library version 3.00 makefile
## DESIGN.EXE, WDESIGN.EXE and GENHELP.EXE
## COPYRIGHT (C) 1990-1992.  All Rights Reserved.
## Zinc Software Incorporated.  Pleasant Grove, Utah  USA

## Uses Zortech C++ 3.00

## Compiler and linker: (Add -g to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=ztc
LINK=blinkx
LIBRARIAN=zorlibx
DOS_CPP_OPTS=-c -a1 -bx -ml
DOS_LINK_OPTS=/NOI
DOS_LIB_OPTS=/C /N /B
WIN_CPP_OPTS=-c -a1 -bx -ml -W2
WIN_LINK_OPTS=/NOI
WIN_LIB_OPTS=/C /N /B
WINDLL_CPP_OPTS=-c -a1 -bx -ml -W2 -D__DLL__
WINDLL_LINK_OPTS=/NOI
WINDLL_LIB_OPTS=/C /N /B
INCLUDE_DIR=.

## Libraries:
DOS_OBJS=
DOS_LIBS=zil fg
WIN_OBJS=
WIN_LIBS=zilw
WINDLL_OBJS=
WINDLL_LIBS=


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obw $<

.cpp.obd:
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obd $<

.rc.res:
	rc -r $<


bin: design.exe wdesign.exe genhelp.exe


genhelp.exe: genhelp.obj
	$(LINK) $(DOS_LINK_OPTS) $(DOS_OBJS)+$*, $*, , $(DOS_LIBS), NUL


design.exe: d_design.obj \
	d_bitmap.obj d_combo.obj d_config.obj d_ctrl.obj d_dialog.obj \
	d_doserr.obj d_file.obj d_frame.obj d_help.obj d_help1.obj \
	d_hlpbar.obj d_hlpmsg.obj d_image.obj d_image1.obj d_jump.obj \
	d_list.obj d_memerr.obj d_resrc.obj d_util.obj
	@echo $(DOS_OBJS)+d_design.obj+>zil.rsp
	@echo d_bitmap.obj+d_combo.obj+d_config.obj+d_ctrl.obj+d_dialog.obj+>>zil.rsp
	@echo d_doserr.obj+d_file.obj+d_frame.obj+d_help.obj+d_help1.obj+>>zil.rsp
	@echo d_hlpbar.obj+d_hlpmsg.obj+d_image.obj+d_image1.obj+d_jump.obj+>>zil.rsp
	@echo d_list.obj+d_memerr.obj+d_resrc.obj+d_util.obj>>zil.rsp
	@echo $*, , $(DOS_LIBS)>>zil.rsp
	@echo NUL>>zil.rsp
	$(LINK) $(DOS_LINK_OPTS) @zil.rsp
	@del zil.rsp


wdesign.exe: wdesign.res d_design.obw \
	d_bitmap.obw d_combo.obw d_config.obw d_ctrl.obw d_dialog.obw \
	d_doserr.obw d_file.obw d_frame.obw d_help.obw d_help1.obw \
	d_hlpbar.obw d_hlpmsg.obw d_image.obw d_image1.obw d_jump.obw \
	d_list.obw d_memerr.obw d_resrc.obw d_util.obw
	@echo $(WIN_OBJS)+d_design.obw+>zil.rsp
	@echo d_bitmap.obw+d_combo.obw+d_config.obw+d_ctrl.obw+d_dialog.obw+>>zil.rsp
	@echo d_doserr.obw+d_file.obw+d_frame.obw+d_help.obw+d_help1.obw+>>zil.rsp
	@echo d_hlpbar.obw+d_hlpmsg.obw+d_image.obw+d_image1.obw+d_jump.obw+>>zil.rsp
	@echo d_list.obw+d_memerr.obw+d_resrc.obw+d_util.obw>>zil.rsp
	@echo $*, , $(WIN_LIBS)>>zil.rsp
	@echo $*.def>>zil.rsp
	$(LINK) $(WIN_LINK_OPTS) @zil.rsp
	rc -k $*.res $*.exe
	@del zil.rsp
