//	Zinc Interface Library - CURSOR.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#ifdef __ZTC__
#include <disp.h>
#endif
#ifdef _MSC_VER
#include <graph.h>
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
#include <mem.h>
#endif
#if !defined(_Windows) & !defined(_WINDOWS)
#include <conio.h>
#endif
#include "ui_evt.hpp"
#pragma hdrstop

UID_CURSOR::UID_CURSOR(DEVICE_STATE _state, DEVICE_IMAGE _image) :
	UI_DEVICE(E_CURSOR, _state), image(_image)
{
	extern void z_cursor_dummy(void);		// Bug fix for Zortech & Microsoft linkers.
	z_cursor_dummy();

	position.column = position.line = 0;
	installed = TRUE;
}

UID_CURSOR::~UID_CURSOR(void)
{
}

#ifdef _WINDOWS
EVENT_TYPE UID_CURSOR::Event(const UI_EVENT &event)
{
	// Switch on the raw code.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_POSITION:
		position = event.position;
		SetCaretPos(position.column, position.line);
		break;
	}

	// Return the control code.
	return (ccode);
}

void UID_CURSOR::Poll(void)
{
}
#else
#define gnd	BACKGROUND
#define BLK	BLACK
static UCHAR _insert[32] =
{
	0, 0, 2, 14,
	BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,
	BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK
};
static UCHAR _overstrike[18] =
{
	0, 0, 1, 14,
	BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK,BLK
};

EVENT_TYPE UID_CURSOR::Event(const UI_EVENT &event)
{
	// Switch on the raw code.
	DEVICE_STATE oldState = state;
	DEVICE_IMAGE oldImage = image;
	UI_POSITION oldPosition = position;
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		oldState = D_OFF;
		break;

	case D_OFF:
	case D_ON:
		state = event.type;
		break;

	case S_POSITION:
		position = event.position;
		if (state == D_HIDE)
			state = D_ON;
		break;

	case DC_INSERT:
	case DC_OVERSTRIKE:
		image = ccode;
		state = D_ON;
		break;
	}

	// Reset the cursor information.
	if (oldImage == image && oldState == state && oldPosition == position)
		return (ccode);
	if (state == D_ON && display->isText && position.column >= 0 &&
		position.column < display->columns && position.line >= 0 &&
		position.line < display->lines)
	{
#ifdef __ZTC__
		disp_move(position.line + 1, position.column + 1);
		disp_setcursortype((image == DC_INSERT) ? DISP_CURSORUL : DISP_CURSORBLOCK);
#endif
#ifdef _MSC_VER
		_settextposition(position.line + 1, position.column + 1);
		_settextcursor((image == DC_INSERT) ? 0x0007 : 0x0707);
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
		gotoxy(position.column + 1, position.line + 1);
		_setcursortype((image == DC_INSERT) ? _SOLIDCURSOR : _NORMALCURSOR);
#endif
	}
	else if (display->isText)
#ifdef __ZTC__
		// Turn cursor off by positioning it off of the screen.
		disp_move(0, 99);
#endif
#ifdef _MSC_VER
		_settextcursor(0x2000);
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
		_setcursortype(_NOCURSOR);
#endif
	else if (state == D_ON)
	{
		UCHAR *bitmapImage = (image == DC_INSERT) ? _insert : _overstrike;
		offset.column = offset.line = 0;
		display->DeviceSet(CURSOR_IMAGE, position.column + offset.column,
			position.line + offset.line, bitmapImage[2],
			display->TextHeight(NULL) + 1, &bitmapImage[4]);
	}
	else
		display->DeviceMove(CURSOR_IMAGE, display->columns, display->lines);

	// Return the control code.
	return (ccode);
}

void UID_CURSOR::Poll(void)
{
	// Make sure the cursor is valid.
	static UI_TIME lastTime;
	if (!installed || state == D_OFF || display->isText)
		return;

	// Check the blink state of the cursor.
	UI_TIME currentTime;
	if (currentTime - lastTime > blinkRate)
	{
		lastTime = currentTime;
		if (state == D_ON)
		{
			display->DeviceMove(CURSOR_IMAGE, display->columns, display->lines);
			state = D_HIDE;
		}
		else
		{
			display->DeviceMove(CURSOR_IMAGE, position.column + offset.column,
				position.line + offset.line);
			state = D_ON;
		}
	}
}
#endif

