//	Zinc Interface Library - DISPLAY.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_dsp.hpp"
#pragma hdrstop

// ----- UI_DISPLAY ---------------------------------------------------------

UI_DISPLAY::UI_DISPLAY(int _isText) : installed(FALSE), isText(_isText),
	isMono(FALSE), columns(0), lines(0), cellWidth(1), cellHeight(1),
	preSpace(2), postSpace(2), miniNumeratorX(1), miniDenominatorX(10),
	miniNumeratorY(1), miniDenominatorY(10)
{
	extern void z_display_dummy(void);		// Bug fix for Zortech & Microsoft linkers.
	z_display_dummy();

	if (!UI_INTERNATIONAL::initialized)
		UI_INTERNATIONAL::Initialize();

	// Set up the default color maps.
	for (int i = 0; i < MAX_DISPLAY_IMAGES; i++)
	{
		displayImage[i].image = displayImage[i].screen = displayImage[i].backup = NULL;
		displayImage[i].region.left = displayImage[i].region.right = -1;
		displayImage[i].region.top = displayImage[i].region.bottom = -1;
	}
}

UI_DISPLAY::~UI_DISPLAY(void)
{
	for (int i = 0; i < MAX_DISPLAY_IMAGES; i++)
	{
		if (displayImage[i].screen)
			delete displayImage[i].screen;
		if (displayImage[i].backup)
			delete displayImage[i].backup;
	}
}

int UI_DISPLAY::RegionInitialize(UI_REGION &region,
	const UI_REGION *clipRegion, int left, int top, int right, int bottom)
{
	region.left = Max(0, left);
	region.top = Max(0, top);
	region.right = Min(columns - 1, right);
	region.bottom = Min(lines - 1, bottom);
	if (clipRegion)
	{
		region.left = Max(region.left, clipRegion->left);
		region.top = Max(region.top, clipRegion->top);
		region.right = Min(region.right, clipRegion->right);
		region.bottom = Min(region.bottom, clipRegion->bottom);
	}
	return (region.left <= region.right && region.top <= region.bottom);
}
