//	Zinc Interface Library Designer - D_COMBO.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_dsn.hpp"
#pragma hdrstop

STORAGE_COMBO_BOX::STORAGE_COMBO_BOX(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_COMBO_BOX(name, directory, file)
{
	file->Load(&childID);
	searchID = windowID[0] = ID_STORAGE_COMBO_BOX;
	windowID[1] = ID_COMBO_BOX;
	windowID[2] = ID_LIST;
	windowID[3] = ID_WINDOW;
}

void STORAGE_COMBO_BOX::Store(const char *name, UI_STORAGE *file, UI_STORAGE_OBJECT *object)
{
	UIW_COMBO_BOX::Store(name, file, object);
	object->Store(childID);
}

void STORAGE_COMBO_BOX::LoadBox(char *currentName)
{
	if (childID == ID_BITMAP_IMAGE)
		_storage->ChDir("~UI_BITMAP");
	else if (childID == ID_ICON_IMAGE)
		_storage->ChDir("~UI_ICON");
	else 
		_storage->ChDir("~UI_HELP");
	for (char *objectName = _storage->FindFirstObject("*"); objectName;
		objectName = _storage->FindNextObject())
	{
		if (objectName[0] != '.')
		{
			UIW_BUTTON *button = new UIW_BUTTON(0, 0, 30, objectName,
				BTF_AUTO_SIZE | BTF_NO_3D, WOF_BORDER);

			if (childID != ID_HELP_CONTEXT &&
				FlagSet(_config->options, OPTION_MENU_BITMAPS))
			{
				UI_STORAGE_OBJECT sObject(*_storage, objectName, 0, UIS_READ);
				USHORT bitmapWidth;
				USHORT bitmapHeight;
				sObject.Load(&bitmapWidth);
				sObject.Load(&bitmapHeight);
				UCHAR *bitmapArray = new UCHAR[bitmapWidth * bitmapHeight];
				sObject.Load(bitmapArray, bitmapWidth, bitmapHeight);
				button->Information(SET_BITMAP_WIDTH, &bitmapWidth);
				button->Information(SET_BITMAP_HEIGHT, &bitmapHeight);
				button->Information(SET_BITMAP_ARRAY, bitmapArray);
				delete bitmapArray;
			}
			if (currentName && !strcmp(objectName, currentName))
				button->woStatus |= WOS_CURRENT;
			*this + button;
		}
	}
}

void STORAGE_COMBO_BOX::LoadBox(UI_HELP_CONTEXT helpNumber)
{
	_storage->ChDir("~UI_HELP");
	char currentName[64] = "";
	char *objectName = _storage->FindFirstID(helpNumber);
	if (objectName)
		strcpy(currentName, objectName);
	LoadBox(currentName);
}

char *STORAGE_COMBO_BOX::GetName(void)
{
	char *returnName = (char *)Information(GET_TEXT, NULL);
	if (!strcmp(returnName, "(None)"))
		returnName = NULL;
	return returnName;
}

int STORAGE_COMBO_BOX::GetID(void)
{
	char *name = (char *)UIW_COMBO_BOX::Information(GET_TEXT, NULL);
	if (name && *name == '\0')
		name = NULL;
	if (name)
	{
		if (childID == ID_BITMAP_IMAGE)
			_storage->ChDir("~UI_BITMAP");
		else if (childID == ID_ICON_IMAGE)
			_storage->ChDir("~UI_ICON");
		else
			_storage->ChDir("~UI_HELP");
		UI_STORAGE_OBJECT sObject(*_storage, name, 0, UIS_READ);
		if (!sObject.objectError)
			return sObject.objectID;
	}
	return 0;
}


