//	Zinc Interface Library Designer - D_CTRL.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#if defined(__ZTC__) | defined(_MSC_VER)
#include <direct.h>
#else
#include <dir.h>
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "ui_dsn.hpp"
#pragma hdrstop

#define USE_HELP_CONTEXTS
#include "design.hpp"

UIW_POP_UP_MENU *_testMenu;

CONTROL_WINDOW::CONTROL_WINDOW(void) :
	UIW_WINDOW("CONTROL_WINDOW", defaultStorage), toolBar(NULL),
	statusBar(NULL), helpBar(NULL), currentObject(NULL), createID(0),
	paste(FALSE)
{
	mainMenu = (UIW_PULL_DOWN_MENU *)UIW_WINDOW::Get("MAIN_MENU");

	int width = relative.right - relative.left + 1;
	relative.left = (display->columns / display->cellWidth - width) / 2;
	relative.right = relative.left + width - 1;
	relative.bottom = relative.top + AddConfigObjects() - 1;
	if (display->isText)
	{
		++relative.bottom;
		UIW_WINDOW::Get("IMAGE_EDIT_ITEM")->woFlags |= WOF_NON_SELECTABLE;
	}

	UpdateStatusBar();
	UpdatePlaceString(0);
}

int CONTROL_WINDOW::AddConfigObjects(void)
{
	int height = 3;
	if (FlagSet(_config->options, OPTION_TOOL_BAR))
	{
		if (_config->toolBar == TOOL_BITMAP)
			height += 2;
		else if (_config->toolBar == TOOL_TEXT)
			height += 3;
		else
			height += 6;
		// Rebuild tool bar according to configutation information.
		if (!toolBar)
		{
			if (statusBar)
			{
				*this - statusBar;
				delete statusBar;
				statusBar = NULL;
			}
			*this + (toolBar = new UIW_TOOL_BAR(0, 0, 0, 0));
			if (display->isText)
				toolBar->paletteMapTable = _textPaletteTable;
			toolBar->helpContext = OBJECT_BAR_HELP;
		}
		toolBar->Destroy();
		for (UI_ELEMENT *element = _config->toolList.First(); element; element = element->Next())
		{
			TOOL_BUTTON_ELEMENT *toolElement = (TOOL_BUTTON_ELEMENT *)element;
			if (toolElement->data.used)
			{
				if (display->isText)
				{
					UIW_BUTTON *button = new UIW_BUTTON(0, 0, 10, toolElement->data.objectName,
							BTF_NO_TOGGLE | BTF_SEND_MESSAGE,
							WOF_BORDER, NULL, (EVENT_TYPE)toolElement->data.createID,
							NULL);
					button->paletteMapTable = _textPaletteTable;
					*toolBar + button;
				}
				else if (_config->toolBar == TOOL_BITMAP)
				{
					*toolBar
						+ new UIW_BUTTON(0, 0, 6, NULL, BTF_NO_TOGGLE |
							BTF_AUTO_SIZE | BTF_SEND_MESSAGE, WOF_JUSTIFY_CENTER,
							NULL, (EVENT_TYPE)toolElement->data.createID,
							toolElement->data.bitmapName);
				}
				else if (_config->toolBar == TOOL_TEXT)
				{
					*toolBar
						+ new UIW_BUTTON(0, 0, 10, toolElement->data.objectName,
							BTF_NO_TOGGLE | BTF_AUTO_SIZE | BTF_SEND_MESSAGE,
							WOF_JUSTIFY_CENTER, NULL, (EVENT_TYPE)toolElement->data.createID,
							NULL);
				}
				else
				{
					*toolBar
						+ new UIW_BUTTON(0, 0, 10, toolElement->data.objectName,
							BTF_NO_TOGGLE | BTF_AUTO_SIZE | BTF_SEND_MESSAGE,
							WOF_JUSTIFY_CENTER, NULL, (EVENT_TYPE)toolElement->data.createID,
							toolElement->data.bitmapName);
				}
			}
		}
	}
	else if (toolBar)
	{
		*this - toolBar;
		delete toolBar;
		toolBar = NULL;
	}
	if (FlagSet(_config->options, OPTION_STATUS_BAR))
	{
		height += 2;
		if (!statusBar)
		{
			*this + (statusBar = new UIW_TOOL_BAR(0, 0, 0, 2, WNF_NO_WRAP,
				WOF_BORDER | WOF_NON_FIELD_REGION, WOAF_NON_CURRENT));
			*statusBar
				+ new UIW_PROMPT(1, 0, "object:")
				+ (objectString = new UIW_STRING(11, 0, 15, NULL, 15,
					STF_NO_FLAGS, WOF_BORDER | WOF_NON_SELECTABLE))
				+ new UIW_PROMPT(1, 1, "stringID:")
				+ (idString = new UIW_STRING(11, 1, 15, NULL, 15, STF_NO_FLAGS,
					WOF_BORDER | WOF_NON_SELECTABLE))
				+ new UIW_PROMPT(28, 0, "pos:")
				+ (posString = new UIW_STRING(34, 0, 10, NULL, 10, STF_NO_FLAGS,
					WOF_BORDER | WOF_NON_SELECTABLE))
				+ new UIW_PROMPT(28, 1, "size:")
				+ (sizeString = new UIW_STRING(34, 1, 10, NULL, 10, STF_NO_FLAGS,
					WOF_BORDER | WOF_NON_SELECTABLE))
				+ new UIW_PROMPT(50, 0, "place object:")
				+ (placeString = new UIW_STRING(50, 1, 15, NULL, 15, STF_NO_FLAGS,
					WOF_BORDER | WOF_NON_SELECTABLE));
			statusBar->helpContext = OBJECT_BAR_HELP;
		}
	}
	else if (statusBar)
	{
		*this - statusBar;
		delete statusBar;
		statusBar = NULL;
	}
	if (FlagSet(_config->options, OPTION_HELP_BAR))
	{
		++height;
		if (!helpBar)
			*this + (helpBar = new HELP_BAR);
	}
	else if (helpBar)
	{
		*this - helpBar;
		delete helpBar;
		helpBar = NULL;
	}
	return height;
}

EVENT_TYPE CONTROL_WINDOW::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the type of event.
	EVENT_TYPE ccode = event.type;
	if (ccode >= FILE_FIRST && ccode <= FILE_LAST)
		FileOption(event);
	else if (ccode >= EDIT_FIRST && ccode <= EDIT_LAST)
		EditOption(event);
	else if (ccode >= RESOURCE_FIRST && ccode <= RESOURCE_LAST)
		ResourceOption(event);
	else if (ccode >= UTIL_FIRST && ccode <= UTIL_LAST)
		UtilOption(event);
	else
		switch (ccode)
		{
		case D_CONFIG_CHANGED:
			relative.bottom = relative.top + AddConfigObjects() *
				display->cellHeight;
#ifndef _WINDOWS
			UIW_WINDOW::Event(UI_EVENT(S_CREATE));
#endif
			*windowManager + this;
			windowManager->screenID = screenID;
			UpdateStatusBar();
			if (createID)
				UpdatePlaceString(createID);
			else if (paste)
			{
				UI_STORAGE_OBJECT sObject(*_storage, "paste", 0, UIS_READ);
				if (!sObject.objectError)
					UpdatePlaceString(sObject.objectID);
			}
			else
				UpdatePlaceString(0);
			break;

		case D_EDIT_OBJECT:
			{
			object = (UI_WINDOW_OBJECT *)event.data;
			char frameName[64];
			OBJECTID searchID = object->SearchID();
			if (searchID == ID_STORAGE_COMBO_BOX)
				searchID = ID_COMBO_BOX;
			else if (searchID == ID_OBJECT_LIST)
				searchID = ID_VT_LIST;
			sprintf(frameName, "UIF_%d", searchID);
			if (display->isText)
				strcat(frameName, "_TEXT");
			defaultStorage->ChDir("~UIW_WINDOW");
			if (defaultStorage->FindFirstObject(frameName))
				*windowManager + new UIW_FRAME_WINDOW(frameName, object);
			}
			break;

		case D_SET_OBJECT:
			currentObject = (UI_WINDOW_OBJECT *)event.data;
			UpdateStatusBar();
			break;

		case D_SET_POSITION:
			if (FlagSet(event.rawCode, M_RIGHT))
			{
				if (createID || paste)
				{
					// Cancel the object placement.
					repeatCreateID = createID;
					createID = 0;
					paste = FALSE;
			   	 	UpdatePlaceString(0);
				}
				else
				{
					if (repeatCreateID)
					{
						createID = repeatCreateID;
					 	UpdatePlaceString(createID);
					}
					else
						EditOption(UI_EVENT(EDIT_PASTE));
				}
			}
			else if ((createID || paste) && currentObject)
			{
				// Create the object.
				UI_WINDOW_OBJECT *newObject = NULL;
				if (createID)
					newObject = CreateObject(createID);
				else
				{
					_storage->ChDir("~");
					UI_STORAGE_OBJECT sObject(*_storage, "paste", 0, UIS_READ);
					if (!sObject.objectError)
						newObject =	UI_WINDOW_OBJECT::New("paste", _storage, &sObject);
					UI_WINDOW_OBJECT *resource = currentObject;
					while (resource->parent)
						resource = resource->parent;

					// Regenerate object's stringID if not unique.
					if (resource->Information(GET_STRINGID_OBJECT, newObject->StringID()))
						newObject->StringID("");
				}
				if (newObject)
				{
					// Position the object.
					int column = event.position.column / display->cellWidth;
					int line = event.position.line / display->cellHeight;
					if (createID == ID_BUTTON)
						++line;
					int width = newObject->relative.right - newObject->relative.left;
					int height = newObject->relative.bottom - newObject->relative.top;
					newObject->relative.left = column;
					newObject->relative.top = line;
					newObject->relative.right = newObject->relative.left + width;
					newObject->relative.bottom = newObject->relative.top + height;

					// Set the edit status of the object.
					newObject->woStatus |= WOS_EDIT_MODE;

					// Place the object.
					if (AddAllowed(currentObject, newObject))
					{
						UI_EVENT tEvent;
						tEvent.type = S_ADD_OBJECT;
						tEvent.data = newObject;
						
						//Attach the object.
						currentObject->Event(tEvent);

						//Make the object current.
						currentObject->Event(tEvent);

						if (FlagSet(newObject->woFlags, WOF_NON_FIELD_REGION))
							currentObject->Information(CHANGED_FLAGS, NULL);

						currentObject->Event(UI_EVENT(S_REDISPLAY));
						currentObject = newObject;
					}
					else
					{
						errorSystem->Beep();
						delete newObject;
						break;
					}
				}
				repeatCreateID = createID;
				createID = 0;
				paste = FALSE;
				UpdateStatusBar();
				UpdatePlaceString(0);
			}
			break;

	 	case S_INITIALIZE:
		case S_CREATE:
			ccode = UIW_WINDOW::Event(event);
			break;

		default:
			if (ccode >= D_CREATE_OBJECT)
			{
				createID = ccode - D_CREATE_OBJECT;
				UpdatePlaceString(createID);
			}
			else
				ccode = UIW_WINDOW::Event(event);
			UI_WINDOW_OBJECT *helpObject = Current();
			if (helpObject == mainMenu)
				helpObject = mainMenu->Current();
			if (helpBar)
				helpBar->Update(helpObject);
			break;
		}

	// Return the control code.
 	return (ccode);
}

void CONTROL_WINDOW::FileOption(const UI_EVENT &event)
{
	char path[128];
	char file[128];
	_storage->StorageName(path);
	_storage->StripFullPath(path, NULL, file, NULL);
	if (!strcmp(file, "UNTITLED.DAT"))
		strcpy(path, "(Untitled)");

	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case FILE_NEW:
	case FILE_OPEN:
		// Warn user before changing files.
		if (_saveNeeded)
		{
			DIALOG_WINDOW dialog("New File", "QUESTION", DIF_YES |
				DIF_NO | DIF_CANCEL, "\r\nSave current file %s?", path);
			EVENT_TYPE userResponce = dialog.Responce();
			if (userResponce == DIALOG_YES)
			{
				// Call Save-As if file has not yet been named.
				if (!strcmp(path, "(Untitled)"))
				{
					UIW_WINDOW *window = new FILE_WINDOW(FILE_SAVE_AS);
					*windowManager + window;

					// Wait until Save-As is completed before continuing.
					int saved = FALSE;
					do
					{
						UI_EVENT event;
						eventManager->Get(event);
						if (event.type == OPTION_OK)
							saved = TRUE;
						windowManager->Event(event);
					} while (windowManager->First() == window);
					if (!saved)
						break;
				}
				else
					FileOption(UI_EVENT(FILE_SAVE));
			}
			else if (userResponce == DIALOG_CANCEL)
				break;
		}
		// Continue.

	case FILE_SAVE_AS:
	case FILE_DELETE:
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		*windowManager + new FILE_WINDOW(ccode);
		eventManager->DeviceState(E_MOUSE, DM_VIEW);
		break;

	case FILE_SAVE:
		eventManager->DeviceState(E_MOUSE, DM_WAIT);

		// Call Save-As if file has not yet been named.
		if (!strcmp(path, "(Untitled)"))
		{
			*windowManager + new FILE_WINDOW(FILE_SAVE_AS);
			eventManager->DeviceState(E_MOUSE, DM_VIEW);
			break;
		}
		SaveFile();
		break;

	case FILE_PREFERENCES:
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		*windowManager + new PREFERENCES_WINDOW;
		eventManager->DeviceState(E_MOUSE, DM_VIEW);
		break;

	case FILE_EXIT:
		eventManager->Put(UI_EVENT(L_EXIT_FUNCTION));
		break;
	}
}

void CONTROL_WINDOW::EditOption(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case EDIT_OBJECT:
		if (currentObject)
		{
			UI_EVENT tEvent;
			tEvent.type = D_EDIT_OBJECT;
			tEvent.data = currentObject;
			Event(tEvent);
		}
		break;

	case EDIT_COPY:
	case EDIT_CUT:
	case EDIT_DELETE:
		if (currentObject)
		{
			if (ccode != EDIT_DELETE)
			{
				// Store the current object;
				eventManager->DeviceState(E_MOUSE, DM_WAIT);
				_storage->ChDir("~");
				UI_STORAGE_OBJECT sObject(*_storage, "paste",
					currentObject->SearchID(), UIS_READWRITE | UIS_CREATE);
				sObject.Store(currentObject->SearchID());
				currentObject->Store("paste", _storage, &sObject);
				repeatCreateID = 0;
			}
			if (ccode != EDIT_COPY)
			{
				if (currentObject->parent)
				{
					// Clear the current object;
					UI_WINDOW_OBJECT *parentObject = currentObject->parent;
					UI_EVENT tEvent;
					tEvent.type = S_SUBTRACT_OBJECT;
					tEvent.data = currentObject;
					parentObject->Event(tEvent);
					parentObject->Event(UI_EVENT(S_REDISPLAY));

					// Make sure object was subtracted.
					if (!parentObject->Get(currentObject->NumberID()))
						delete currentObject;
					currentObject = parentObject;
					UpdateStatusBar();
				}
				else
				{
					DIALOG_WINDOW dialog("Delete", "QUESTION", DIF_OK |
						DIF_CANCEL, "Resource %s will be deleted!",
						currentObject->StringID());
					if (dialog.Responce() != DIALOG_CANCEL)
					{
						*windowManager - currentObject;
						delete currentObject;
						currentObject = NULL;
					}
				}
			}
		}
		else
			errorSystem->Beep();
		break;

	case EDIT_PASTE:
		{
			// See if a paste object exists in the paste buffer.
			_storage->ChDir("~");
			UI_STORAGE_OBJECT sObject(*_storage, "paste", 0, UIS_READ);
			if (!sObject.objectError)
			{
				paste = TRUE;
				createID = 0;
				UpdatePlaceString(sObject.objectID);
			}
			else
			{
				DIALOG_WINDOW dialog("Error!", "ASTERISK", DIF_OK,
					"The paste buffer is empty.");
				dialog.Responce();
			}
		}
		break;

	case EDIT_SIZE:
	case EDIT_MOVE:
		// Make sure we can move/size the object.
		if (currentObject->parent && !FlagSet(currentObject->woFlags, WOF_NON_FIELD_REGION) &&
			!(ccode == EDIT_SIZE && currentObject->Inherited(ID_ICON)))
		{
			UI_WINDOW_OBJECT *currentResource = NULL;
			if (currentObject)
			{
				currentResource = currentObject;
				while(currentResource->parent)
					currentResource = currentResource->parent;
			}
			if (currentResource)
			{
				*windowManager + currentResource;
				UI_EVENT tEvent;
				tEvent.type = (ccode == EDIT_SIZE) ? L_SIZE : L_MOVE;
				if (ccode == EDIT_MOVE)
					tEvent.rawCode = M_LEFT_CHANGE | M_TOP_CHANGE |
						M_RIGHT_CHANGE | M_BOTTOM_CHANGE;
				else
					tEvent.rawCode = M_RIGHT_CHANGE | M_BOTTOM_CHANGE;
				currentObject->Modify(tEvent);
				UpdateStatusBar();
			}
		}
		else
		{
			errorSystem->Beep();
			break;
		}
		break;
	}
	eventManager->DeviceState(E_MOUSE, DM_VIEW);
}

void CONTROL_WINDOW::ResourceOption(const UI_EVENT &event)
{
	// Find the current resource.
	UI_WINDOW_OBJECT *currentResource = NULL;
	if (currentObject)
	{
		currentResource = currentObject;
		while(currentResource->parent)
			currentResource = currentResource->parent;
	}

	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case RESOURCE_CREATE:
		{
		// Create a generic window (resource).
		UIW_WINDOW *window = UIW_WINDOW::Generic((display->columns /
			display->cellWidth - 30) / 2, (display->lines /
			display->cellHeight - 8) / 2, 30, 8, "Title");

		// Set edit mode and save status for the window.
		window->woStatus |= WOS_EDIT_MODE;
		window->userFlags = window->woAdvancedFlags;
		window->woAdvancedFlags |= WOAF_LOCKED;

		// Generate a unique ID for the window.
		_storage->ChDir("~UIW_WINDOW");
		int resourceNumber = 1;
		for (char *objectName = _storage->FindFirstObject("*"); objectName;
			objectName = _storage->FindNextObject())
		{
			if (!strncmp(objectName, "RESOURCE_", 9))
			{
				int i = atoi(objectName + 9);
				if (i >= resourceNumber)
					resourceNumber = i + 1;
			}
		}
		for (UI_WINDOW_OBJECT *object = windowManager->First(); object; object = object->Next())
		{
			char *objectName = object->StringID();
			if (!strncmp(objectName, "RESOURCE_", 9))
			{
				int i = atoi(objectName + 9);
				if (i >= resourceNumber)
					resourceNumber = i + 1;
			}
		}
		char name[32];
		sprintf(name, "RESOURCE_%d", resourceNumber);
		window->StringID(name);

		// Place window on screen.
		*windowManager + window;
		currentObject = window;
		UpdateStatusBar();
		}
		break;

	case RESOURCE_LOAD:
	case RESOURCE_DELETE:
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		*windowManager + new RESOURCE_WINDOW(ccode);
		break;

	case RESOURCE_STORE_AS:
		if (currentResource)
		{
			eventManager->DeviceState(E_MOUSE, DM_WAIT);
			*windowManager + new RESOURCE_WINDOW(ccode, currentResource);
		}
		else
			errorSystem->Beep();
		break;

	case RESOURCE_ADD:
		currentObject = (UI_WINDOW_OBJECT *)event.data; 
		*windowManager + currentObject;
		UpdateStatusBar();
		break;

	case RESOURCE_EDIT:
		if (currentResource)
		{
			// Send edit message.
			UI_EVENT tEvent;
			tEvent.type = D_EDIT_OBJECT;
			tEvent.data = currentResource;
			Event(tEvent);
		}
		else
			errorSystem->Beep();
		break;

	case RESOURCE_STORE:
	case RESOURCE_CLEAR:
		if (currentResource)
		{

			EVENT_TYPE responce = 0;
			if (ccode == RESOURCE_CLEAR)
			{
				DIALOG_WINDOW dialog("Clear Resource", "QUESTION", DIF_YES |
					DIF_NO | DIF_CANCEL, "%s\r\n\r\nStore resource before clearing?",
					currentResource->StringID());
				responce = dialog.Responce();
			}
			if (ccode == RESOURCE_STORE || responce == DIALOG_YES)
			{
				eventManager->DeviceState(E_MOUSE, DM_WAIT);
				// Store the resource.
				currentResource->woAdvancedFlags = currentResource->userFlags;
				currentResource->Store(currentResource->StringID(), _storage);
				_saveNeeded = TRUE;
			}
			if (ccode == RESOURCE_CLEAR && responce != DIALOG_CANCEL)
			{
				// Clear the resource.
				*windowManager - currentResource;
				delete currentResource;
				for (currentResource = windowManager->First(); currentResource &&
					!FlagsSet(currentResource->woStatus, WOS_EDIT_MODE);
					currentResource = currentResource->Next())
				;
				currentObject = currentResource;
				UpdateStatusBar();
			}
		}
		else
			errorSystem->Beep();
		break;

	case RESOURCE_TEST:
		{
		UI_STORAGE testStorage("test.$$$", UIS_READWRITE | UIS_CREATE);
		if (testStorage.storageError)
		{
			errorSystem->Beep();
			break;
		}
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		UI_HELP_SYSTEM *saveHelpSystem = UI_WINDOW_OBJECT::helpSystem;
		UI_STORAGE *saveStorage = UI_WINDOW_OBJECT::defaultStorage;
		UI_LIST saveList;
		char fileName[128];
		_storage->StorageName(fileName);
		UI_WINDOW_OBJECT::helpSystem = new UI_HELP_SYSTEM(fileName);
		UI_WINDOW_OBJECT::defaultStorage = _storage;
		windowManager->screenID = ID_SCREEN;
		*windowManager - this;
 		UI_WINDOW_OBJECT *object = windowManager->Last();
		while (object)
		{
			if (FlagSet(object->woStatus, WOS_EDIT_MODE))
				object->Store(object->StringID(), &testStorage);
			object->woAdvancedFlags &= ~WOAF_LOCKED;
			*windowManager - object;
			saveList + object;
	 		object = windowManager->Last();
		}
		UIW_WINDOW *testWindow = new UIW_WINDOW(0, 0, 11, 3, WOF_NO_FLAGS);
		*testWindow
			+ new UIW_TITLE("Testing")
			+ new UIW_BUTTON(0, 0, 0, "Exit Test", BTF_AUTO_SIZE |
				BTF_SEND_MESSAGE, WOF_JUSTIFY_CENTER | WOF_NON_FIELD_REGION,
				NULL, RESOURCE_END_TEST);
		*windowManager + testWindow;
		windowManager->screenID = testWindow->screenID;
		testStorage.ChDir("~UIW_WINDOW");
		char *resourceName = testStorage.FindFirstObject("*");
		while (resourceName)
		{
			if (strcmp(resourceName, ".") && strcmp(resourceName, ".."))
			{
				UI_WINDOW_OBJECT *object = new UIW_WINDOW(resourceName, &testStorage);
				if (!FlagSet(object->woStatus, WOS_READ_ERROR))
				{
					object->woAdvancedFlags = object->userFlags & ~WOAF_MODAL;
					*windowManager + object;
				}
				else
					delete object;
			}
			testStorage.ChDir("~UIW_WINDOW");
			resourceName = testStorage.FindNextObject();
		}
		EVENT_TYPE ccode;
  		UI_EVENT tEvent;
		do
		{
			eventManager->Get(tEvent);
			ccode = windowManager->Event(tEvent);
		} while (tEvent.type != RESOURCE_END_TEST &&  ccode != L_EXIT);
		windowManager->screenID = ID_SCREEN;
 		object = windowManager->Last();
		while (object)
		{
			*windowManager - object;
			delete object;
	 		object = windowManager->Last();
		}
 		object = (UI_WINDOW_OBJECT *)saveList.First();
		while (object)
		{
			saveList - object;
			*windowManager + object;
	 		object = (UI_WINDOW_OBJECT *)saveList.First();
		}
		*windowManager + this;
		windowManager->screenID = screenID;
		delete UI_WINDOW_OBJECT::helpSystem;
		UI_WINDOW_OBJECT::helpSystem = saveHelpSystem;
		UI_WINDOW_OBJECT::defaultStorage = saveStorage;
		}
	}
	eventManager->DeviceState(E_MOUSE, DM_VIEW);
}

void CONTROL_WINDOW::UtilOption(const UI_EVENT &event)
{
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case UTIL_BITMAP:
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		*windowManager + new BITMAP_EDITOR(ID_BITMAP_IMAGE);
		break;

	case UTIL_HELP:
		eventManager->DeviceState(E_MOUSE, DM_WAIT);
		*windowManager + new HELP_EDITOR;
		break;
 	}
	eventManager->DeviceState(E_MOUSE, DM_VIEW);
}

void CONTROL_WINDOW::UpdatePlaceString(OBJECTID objectID)
{
	int i;
	if (statusBar)
	{
		for (i = 0; _toolData[i].data; i++)
		{
			if (_toolData[i].value == objectID + D_CREATE_OBJECT)
			{
				placeString->DataSet(_toolData[i].text);
		 		break;
			}
		}
		if (!_toolData[i].data)
			placeString->DataSet("None");
	}
}

void CONTROL_WINDOW::UpdateStatusBar(void)
{
	if (statusBar)
	{
		if (currentObject)
		{
			for (int i = 0; _toolData[i].data; i++)
			if (_toolData[i].value == D_CREATE_OBJECT + currentObject->SearchID())
			{
				objectString->DataSet(_toolData[i].text);
				break;
			}
			idString->DataSet(currentObject->StringID());
			char coordinates[15];
			sprintf(coordinates, "%d, %d", currentObject->true.left / display->cellWidth,
				currentObject->true.top / display->cellHeight);
			posString->DataSet(coordinates);
			sprintf(coordinates, "%d, %d", (currentObject->true.right -
				currentObject->true.left) / display->cellWidth, (currentObject->true.bottom -
				currentObject->true.top) / display->cellHeight);
			sizeString->DataSet(coordinates);
		}
		else
		{
			objectString->DataSet("None");
			idString->DataSet(NULL);
			posString->DataSet(NULL);
			sizeString->DataSet(NULL);
		}
	}
}

void CONTROL_WINDOW::SetTitle(void)
{
	char fileName[128];
	char filePath[128];
	_storage->StorageName(filePath);
	UI_STORAGE::StripFullPath(filePath, 0, fileName);
	if (!strcmp(fileName, "UNTITLED.DAT"))
		strcpy(fileName, "(Untitled)");
	sprintf(filePath, "Zinc Designer - %s", fileName);
	Information(SET_TEXT, filePath);
}

class USER_FUNCTION_ELEMENT : public UI_ELEMENT
{
public:
	char *userFunctionName;

	USER_FUNCTION_ELEMENT(char *_userFunctionName)
	{ userFunctionName = _userFunctionName; }
	~USER_FUNCTION_ELEMENT(void)
	{ delete userFunctionName; }
};

static int FindUserFunctionName(void *element1, void *element2)
{
	return strcmp(((USER_FUNCTION_ELEMENT *)element1)->userFunctionName, (char *)element2);
}

void SaveFile(char *newName, int memErr)
{
	UI_WINDOW_OBJECT::eventManager->DeviceState(E_MOUSE, DM_WAIT);

	char fileName[256];
	if (newName)
		strcpy(fileName, newName);
	else
		_storage->StorageName(fileName);

	UIW_WINDOW *saveWindow = new UIW_WINDOW("SAVE_WINDOW", UI_WINDOW_OBJECT::defaultStorage);
	((UIW_TITLE *)saveWindow->Information(GET_STRINGID_OBJECT, "NUMID_TITLE"))->Information(SET_TEXT, fileName);
	Center(saveWindow);
	*UI_WINDOW_OBJECT::windowManager + saveWindow;
	UI_WINDOW_OBJECT *messageField = (UI_WINDOW_OBJECT *)saveWindow->Information(GET_STRINGID_OBJECT, "MESSAGE_FIELD");

#ifndef _WINDOWS
	messageField->paletteMapTable = _textPaletteTable;
#endif

 	_storage->ChDir("~UIW_WINDOW");

	// Store all resources on the screen before saveing.
	messageField->Information(SET_TEXT, "Storing resources...");
	UI_WINDOW_OBJECT *object = UI_WINDOW_OBJECT::windowManager->First();
	while (object)
	{
		UI_WINDOW_OBJECT *tObject = object->Next();
		if (FlagSet(object->woStatus, WOS_EDIT_MODE))
		{
			object->woAdvancedFlags = object->userFlags;
			object->Store(object->StringID(), _storage);
			if (memErr)
			{
				*UI_WINDOW_OBJECT::windowManager - object;
				delete object;
			}
		}
		object = tObject;
	}
	
	// Generate the HPP file.
	messageField->Information(SET_TEXT, "Generating .HPP file...");
	UI_STORAGE::ChangeExtension(fileName, ".HPP");
	FILE *includeFile = fopen(fileName, "w+");

	if (!includeFile)
		return;

	_storage->ChDir("~UI_HELP");
	for (char *helpName = _storage->FindFirstObject("*"); helpName;
		helpName = _storage->FindNextObject())
	{
		if (helpName[0] != '.')
		{
			UI_STORAGE_OBJECT sObject(*_storage, helpName, 0, UIS_READ);
			char *title = NULL;
			sObject.Load(&title);
			fprintf(includeFile, "const UI_HELP_CONTEXT %-32s = 0x%04X; // %s\n", helpName, sObject.objectID, title);
		}
	}
	fprintf(includeFile, "\n\n");

	char line[256];
	_storage->ChDir("~UI_HPP");
	for (char *entry = _storage->FindFirstObject("*"); entry; entry = _storage->FindNextObject())
		if (strcmp(entry, ".") && strcmp(entry, "..") && strcmp(entry, "HELP_CONTEXTS"))
		{
			fprintf(includeFile, "#ifdef USE_%s\n", entry);
			UI_STORAGE_OBJECT hppEntry(*_storage, entry, 0, UIS_READ);
			for (hppEntry.Load(line, 256); strcmp(line, ""); hppEntry.Load(line, 256))
				fprintf(includeFile, "%s\n", line);
			fprintf(includeFile, "#endif // USE_%s\n\n", entry);
		}
	fclose (includeFile);

	// Write the .cpp file.
	messageField->Information(SET_TEXT, "Generating .CPP file...");
	for (int i = 0; UI_WINDOW_OBJECT::objectTable[i].data; i++)
		UI_WINDOW_OBJECT::objectTable[i].flags = FALSE;
	_storage->ChDir("~UI_CPP");
	UI_LIST userFunctionList;
	UI_LIST compareFunctionList;
	for (char *resourceDir = _storage->FindFirstObject("*"); resourceDir;
		resourceDir = _storage->FindNextObject())
	{
		if (resourceDir[0] != '.')
		{
			_storage->ChDir(resourceDir);
			UI_STORAGE_OBJECT objectIDEntry(*_storage, "OBJECTID", 0, UIS_READ);
			if (!objectIDEntry.objectError)
			{
				OBJECTID objectID;
				do
				{
					objectIDEntry.Load(&objectID);
					for (int i = 0; UI_WINDOW_OBJECT::objectTable[i].data; i++)
						if (UI_WINDOW_OBJECT::objectTable[i].value == objectID)
							UI_WINDOW_OBJECT::objectTable[i].flags = TRUE;
				} while (objectID);
			}
			UI_STORAGE_OBJECT userFuncEntry(*_storage, "USER_FUNCTION", 0, UIS_READ);
			if (!userFuncEntry.objectError)
			{
				char *functionName;
				do
				{
					userFuncEntry.Load(&functionName);
					if (functionName && !userFunctionList.Get(FindUserFunctionName, functionName))
						userFunctionList.Add(new USER_FUNCTION_ELEMENT(functionName));
				} while (functionName);
			}
			UI_STORAGE_OBJECT compareFuncEntry(*_storage, "COMPARE_FUNCTION", 0, UIS_READ);
			if (!compareFuncEntry.objectError)
			{
				char *functionName;
				do
				{
					compareFuncEntry.Load(&functionName);
					if (functionName && !compareFunctionList.Get(FindUserFunctionName, functionName))
						compareFunctionList.Add(new USER_FUNCTION_ELEMENT(functionName));
				} while (functionName);
			}
			_storage->ChDir("..");
		}
	}
	UI_STORAGE::ChangeExtension(fileName, ".CPP");
	FILE *jumpFile = fopen(fileName, "w+");

	if (!jumpFile)
		return;

	fprintf(jumpFile, "#include <ui_win.hpp>\n");
 	fprintf(jumpFile, "#pragma hdrstop\n\n");
	fprintf(jumpFile, "void z_jump_dummy(void) { }   //Bug fix for Zortech & Microsoft linkers.\n\n");

	for (UI_ELEMENT *element = userFunctionList.First(); element; element = element->Next())
		fprintf(jumpFile, "extern EVENT_TYPE %s(UI_WINDOW_OBJECT *, UI_EVENT &, EVENT_TYPE);\n",
			((USER_FUNCTION_ELEMENT *)element)->userFunctionName);

	for (element = compareFunctionList.First(); element; element = element->Next())
		fprintf(jumpFile, "extern int %s(void *, void *);\n",
			((USER_FUNCTION_ELEMENT *)element)->userFunctionName);

	fprintf(jumpFile, "\nstatic UI_ITEM _userTable[] =\n{\n");
	for (element = userFunctionList.First(); element; element = element->Next())
		fprintf(jumpFile, "\t{ 0, %s, \"%s\", 0 },\n", ((USER_FUNCTION_ELEMENT *)element)->userFunctionName,
			((USER_FUNCTION_ELEMENT *)element)->userFunctionName);

	for (element = compareFunctionList.First(); element; element = element->Next())
		fprintf(jumpFile, "\t{ 0, %s, \"%s\", 0 },\n", ((USER_FUNCTION_ELEMENT *)element)->userFunctionName,
			((USER_FUNCTION_ELEMENT *)element)->userFunctionName);
	fprintf(jumpFile, "\t{ ID_END, NULL, NULL, 0 }\n};\n");
	fprintf(jumpFile, "UI_ITEM *UI_WINDOW_OBJECT::userTable = _userTable;\n\n");

	fprintf(jumpFile, "static UI_ITEM _objectTable[] =\n{\n");
	for (i = 0; UI_WINDOW_OBJECT::objectTable[i].data; i++)
		if (UI_WINDOW_OBJECT::objectTable[i].flags)
			fprintf(jumpFile, "\t{ ID_%s, &UIW_%s::New, \"%s\", 0 },\n",
				UI_WINDOW_OBJECT::objectTable[i].text, UI_WINDOW_OBJECT::objectTable[i].text,
				UI_WINDOW_OBJECT::objectTable[i].text);

	fprintf(jumpFile, "\t{ ID_END, NULL, NULL, 0 }\n};\n");
	fprintf(jumpFile, "UI_ITEM *UI_WINDOW_OBJECT::objectTable = _objectTable;\n");
	fclose (jumpFile);

	messageField->Information(SET_TEXT, "Writing data file...");
	if (newName)
	 	_storage->SaveAs(newName, _config->backups);
	else
	 	_storage->Save(_config->backups);
	_saveNeeded = FALSE;

	*UI_WINDOW_OBJECT::windowManager - saveWindow;
	delete saveWindow;

	UI_WINDOW_OBJECT::eventManager->DeviceState(E_MOUSE, DM_VIEW);
}

