//	Zinc Interface Library Designer - D_DESIGN.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#if defined(__ZTC__) | defined(_MSC_VER)
#include <direct.h>
#else
#include <dir.h>
#endif
#include <string.h>
#include <ctype.h>
#include <dos.h>
#include <stdlib.h>
#include "ui_dsn.hpp"
#define USE_HELP_CONTEXTS
#include "design.hpp"
#pragma hdrstop

// Increase stack size
#if defined(__ZTC__)
unsigned _stack = 8192;
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
extern unsigned _stklen = 8192;
#endif

// Global Variables
CONTROL_WINDOW *_controlWindow;
UI_STORAGE *_storage = NULL;
int _saveNeeded = FALSE;
void *_errorMemory;

static EVENT_TYPE ExitFunction(UI_DISPLAY *, UI_EVENT_MANAGER *eventManager,
	UI_WINDOW_MANAGER *windowManager)
{
	if (UI_WINDOW_OBJECT::defaultStorage == _storage)
		return L_EXIT;
	for (UI_WINDOW_OBJECT *object = windowManager->First(); object; object = object->Next())
		if (FlagSet(object->woStatus, WOS_EDIT_MODE))
			_saveNeeded = TRUE;

	char path[128];
	char file[128];
	EVENT_TYPE responce;
	if (_saveNeeded)
	{
		_storage->StorageName(path);
		_storage->StripFullPath(path, NULL, file, NULL);
		if (!strcmp(file, "UNTITLED.DAT"))
			strcpy(path, "(Untitled)");
		DIALOG_WINDOW dialog("Exit", "QUESTION", DIF_YES | DIF_NO | DIF_CANCEL,
			"Save file %s before exiting?", path);
		responce = dialog.Responce();
	}
	else
	{
		DIALOG_WINDOW dialog("Exit", "ASTERISK", DIF_OK | DIF_CANCEL,
			"This will close Zinc Designer.");
		responce = dialog.Responce();
	}
	if (responce == DIALOG_YES)
	{
		if (!strcmp(path, "(Untitled)"))
		{
			// Wait for file to be saved before exiting.
			int saved = FALSE;
			UIW_WINDOW *window = new FILE_WINDOW(FILE_SAVE_AS);
			*windowManager + window;
			// Wait until Save-As is completed before continuing.
			do
			{
				UI_EVENT event;
				eventManager->Get(event);
				if (event.type == OPTION_OK)
					saved = TRUE;
				windowManager->Event(event);
			} while (windowManager->First() == window);
			if (saved)
				eventManager->Put(UI_EVENT(L_EXIT));
		}
		else
		{
			eventManager->Put(UI_EVENT(FILE_SAVE));
			eventManager->Put(UI_EVENT(L_EXIT));
		}
	}
	else if (responce == DIALOG_OK || responce == DIALOG_NO)
		eventManager->Put(UI_EVENT(L_EXIT));
	return 0;
}

#if defined(_WINDOWS) | defined(_Windows)
#pragma argsused
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
	UI_STORAGE::searchPath = new UI_PATH();

	char buffer[128];
	strcpy(buffer, lpszCmdLine);
	char *path = strtok(buffer, " ");
	while (path && !isalpha(*path))
		path = strtok(NULL, " ");

	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);
#else
main(int argc, char *argv[])
{
	UI_STORAGE::searchPath = new UI_PATH(argv[0]);
	char startUpDir[128];
	int startUpDrive;
	_errorMemory = new char[8192];

#if defined(__ZTC__)
	getcwd(startUpDir, 128);
	dos_getdrive(&startUpDrive);

	extern void (*_new_handler)();
	extern void NewHandler(void);
	_new_handler = NewHandler;

	extern int _cdecl CriticalErrorHandler(int *ax, int *di);
	_cerror_handler = CriticalErrorHandler;
	cerror_open();
#endif
#if defined(_MSC_VER)
	getcwd(startUpDir, 128);
	_dos_getdrive(&startUpDrive);

	extern int NewHandler(size_t size);
	_set_new_handler(NewHandler);

	extern void CriticalErrorHandler(unsigned deverror, unsigned errcode, unsigned devhdr);
   	_harderr(CriticalErrorHandler);
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	getcwd(startUpDir, 128);
	startUpDrive = getdisk();

	extern void (*_new_handler)();
	extern void NewHandler(void);
	_new_handler = NewHandler;

	extern int CriticalErrorHandler(int errval, int ax, int bp, int si);
   	harderr(CriticalErrorHandler);
#endif

	char *path = NULL;
	char pathBuffer[128];
	UI_DISPLAY *display = NULL;
	for (int argnum = 2; argnum <= argc; argnum++)
	{
		if (isalpha(*argv[argnum - 1]))
		{
			strcpy(pathBuffer, argv[argnum - 1]);
			path = pathBuffer;
		}
		else if ((!strcmp("/t", argv[argnum - 1]) || !strcmp("/T", argv[argnum - 1]) ||
			!strcmp("+t", argv[argnum - 1]) || !strcmp("+T", argv[argnum - 1])) && !display)
			display = new UI_TEXT_DISPLAY;
	}

	if (!display)
	{
#if defined(__ZTC__)
		display = new UI_FG_DISPLAY;
#endif
#if defined(_MSC_VER)
		display = new UI_MSC_DISPLAY;
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
		UI_BGI_DISPLAY::searchPath = UI_STORAGE::searchPath;
		display = new UI_BGI_DISPLAY;
#endif
	}

#endif

	UID_KEYBOARD::breakHandlerSet = L_EXIT_FUNCTION;

	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display,
		eventManager, ExitFunction);

	extern void ReadConfiguration(void);
	ReadConfiguration();

	// Initialize the static information.
	UI_WINDOW_OBJECT::errorSystem = new UI_ERROR_SYSTEM;
	UI_WINDOW_OBJECT::helpSystem = new UI_HELP_SYSTEM("design.znc", windowManager,
		ABOUT_DESIGN_HELP);

	if (!path)
		path = "UNTITLED.DAT";
	char fileName[128];
	char filePath[128];
	char objectName[128];
	UI_STORAGE::StripFullPath(path, filePath, fileName, objectName);

	if (*filePath && filePath[ui_strlen(filePath) - 1] != '\\' &&
		filePath[ui_strlen(filePath) - 1] != ':')
		strcat(filePath, "\\");

	strcat(filePath, fileName);
	strupr(objectName);

	UI_WINDOW_OBJECT::defaultStorage = new UI_STORAGE("design.znc", UIS_READ);

	_storage = NULL;
	if (!strchr(filePath, '.'))
		UI_STORAGE::ChangeExtension(filePath, ".DAT");
	if (!UI_STORAGE::ValidName(filePath, TRUE))
		strcpy(filePath, "UNTITLED.DAT");
	if (strcmp(filePath, "UNTITLED.DAT"))
	{
		if (UI_STORAGE::ValidName(filePath, FALSE))
			_storage = new UI_STORAGE(filePath, UIS_READWRITE);
		else
		{
			DIALOG_WINDOW dialog("Open", "QUESTION", DIF_YES | DIF_NO,
				"File %s is not found.\n\nDo you wish to create it?", filePath);
			if (dialog.Responce() == DIALOG_YES)
			{
				_storage = new UI_STORAGE(filePath, UIS_READWRITE | UIS_CREATE);
				if (!_storage->storageError)
				{
					_storage->MkDir("UIW_WINDOW");
					_storage->MkDir("UI_BITMAP");
					_storage->MkDir("UI_ICON");
					_storage->MkDir("UI_HELP");
				}
			}
			else
				strcpy(filePath, "UNTITLED.DAT");
			objectName[0] = '\0';
		}
	}

	if (!_storage)
	{
		_storage = new UI_STORAGE(filePath, UIS_READWRITE | UIS_CREATE);
		if (!_storage->storageError)
		{
			_storage->MkDir("UIW_WINDOW");
			_storage->MkDir("UI_BITMAP");
			_storage->MkDir("UI_ICON");
			_storage->MkDir("UI_HELP");
		}
	}
	if (UI_WINDOW_OBJECT::defaultStorage->storageError)
	{
		DIALOG_WINDOW dialog("Error", NULL, DIF_OK,
			"Could not open data file 'DESIGN.ZNC.'");
		dialog.Responce();
	}
	else if (_storage->storageError)
	{
		DIALOG_WINDOW dialog("Error", "EXCLAMATION", DIF_OK,
			"Unable to create work file.");
		dialog.Responce();
	}
	else
	{
		_controlWindow = new CONTROL_WINDOW;

		*windowManager
			+ _controlWindow;
 		windowManager->screenID = _controlWindow->screenID;


		if (_storage)
		{
			_controlWindow->SetTitle();
			if (objectName && *objectName != '\0')
			{
				_storage->ChDir("~UIW_WINDOW");
				if (_storage->FindFirstObject(objectName))
				{
					UI_WINDOW_OBJECT::defaultStatus |= WOS_EDIT_MODE;
					UIW_WINDOW *resource = new UIW_WINDOW(objectName, _storage);
					UI_WINDOW_OBJECT::defaultStatus &= ~WOS_EDIT_MODE;
					resource->userFlags = resource->woAdvancedFlags;
					resource->woAdvancedFlags = WOAF_LOCKED;
					*windowManager + resource;
				}
				else
				{
					DIALOG_WINDOW dialog("Load", "ASTERISK", DIF_OK,
						"%s\r\n\r\nResource not found.", objectName);
					dialog.Responce();
				}
			}
		}

		EVENT_TYPE ccode;
		do
		{
			UI_EVENT event;
			eventManager->Get(event);
			if (event.type >= D_DESIGNER_FIRST && event.type <= D_DESIGNER_LAST)
				ccode = _controlWindow->Event(event);
			else
				ccode = windowManager->Event(event);
		} while (ccode != L_EXIT);
	}

	if (_storage)
		delete _storage;
#ifndef _WINDOWS
#if defined(__ZTC__)
	dos_setdrive(startUpDrive, &startUpDrive);
	chdir(startUpDir);
#endif
#if defined(_MSC_VER)
	_dos_setdrive(startUpDrive, &startUpDrive);
	chdir(startUpDir);
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	setdisk(startUpDrive);
	chdir(startUpDir);
#endif
	if (_errorMemory)
		delete _errorMemory;
#endif

	delete windowManager;
	delete eventManager;
	delete display;
#ifndef _WINDOWS
	delete UI_STORAGE::searchPath;
#endif

	return (0);
}
