//	Zinc Interface Library Designer - D_DOSERR.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <dos.h>
#include "ui_dsn.hpp"
#pragma hdrstop

#ifndef _WINDOWS

#define IGNORE			0
#define RETRY			1
#define ABORT			2

int _dosError;
static int drive;
static int errorCode;

// Error messages used by the error handler.
static char *errorMessage[] =
{
	"Disk write protect error",
	"Unknown disk drive",
	"Drive not ready error",
	"Unknown command error",
	"CRC data error",
	"Bad drive request structure length",
	"Disk seek error",
	"Unknown disk format error",
	"Disk sector not found",
	"Printer out of paper",
	"Unable to write data",
	"Unable to read data",
	"General hardware error",
	"Unknown hardware error",
	"Unknown hardware error",
	"Invalid disk change"
};

#if defined(__ZTC__)
int _cdecl CriticalErrorHandler(int *ax, int *di)
{
	_dosError = TRUE;
	drive = *ax & 0x00FF;
	errorCode = *di & 0x00FF;
	*ax = ABORT;
	return ABORT;
}
#endif
#if defined(_MSC_VER)
extern void CriticalErrorHandler(unsigned deverror, unsigned errcode, unsigned)
{
	_dosError = TRUE;
	drive = deverror & 0x00FF;
	errorCode = errcode & 0x00FF;
	_hardretn(ABORT);
	return;
}
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
extern int CriticalErrorHandler(int errval, int ax, int, int)
{
	_dosError = TRUE;
	drive = ax & 0x00FF;
	errorCode = errval & 0x00FF;
	hardretn(ABORT);
	return ABORT;
}
#endif

EVENT_TYPE GetErrorResponce()
{
	DIALOG_WINDOW dialog("Disk Error!", "EXCLAMATION", DIF_ABORT | DIF_RETRY,
		"%s on drive %c.", errorMessage[errorCode], 'A' + drive);
	EVENT_TYPE responce = dialog.Responce();
	if (responce == DIALOG_RETRY)
		_dosError = FALSE;
	return responce;
}
#endif


