//	Zinc Interface Library - G_DISP.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_dsp.hpp"
#pragma hdrstop

void z_display_dummy(void) { }	// Bug fix for Zortech & Microsoft linkers.

static UI_PALETTE __backgroundPalette =
{
	' ', attrib(BLACK, LIGHTBLUE), attrib(MONO_BLACK, MONO_NORMAL),
	PTN_BACKGROUND_FILL, CYAN, CYAN, BW_WHITE, BW_WHITE, GS_GRAY, GS_GRAY
};

static UI_PALETTE __xorPalette =
{
	'\260', attrib(WHITE, BLACK), attrib(MONO_HIGH, MONO_NORMAL),
	PTN_SOLID_FILL, WHITE, BLACK, BW_WHITE, BW_BLACK, GS_GRAY, GS_BLACK
};

#ifdef _WINDOWS
static UI_PALETTE __colorMap[16] =
{
	{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_BLACK, RGB_BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(BLUE, BLUE), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_BLUE, RGB_BLUE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(GREEN, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_GREEN, RGB_GREEN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(CYAN, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_CYAN, RGB_CYAN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(RED, RED), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_RED, RGB_RED, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(MAGENTA, MAGENTA), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_MAGENTA, RGB_MAGENTA, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(BROWN, BROWN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_BROWN, RGB_BROWN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_RGB_COLOR, RGB_LIGHTGRAY, RGB_LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(DARKGRAY, DARKGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_RGB_COLOR, RGB_DARKGRAY, RGB_DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTBLUE, LIGHTBLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_RGB_COLOR, RGB_LIGHTBLUE, RGB_LIGHTBLUE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTGREEN, LIGHTGREEN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_RGB_COLOR, RGB_LIGHTGREEN, RGB_LIGHTGREEN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTCYAN, LIGHTCYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_RGB_COLOR, RGB_LIGHTCYAN, RGB_LIGHTCYAN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTRED, LIGHTRED), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_RGB_COLOR, RGB_LIGHTRED, RGB_LIGHTRED, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTMAGENTA, LIGHTMAGENTA), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_RGB_COLOR, RGB_LIGHTMAGENTA, RGB_LIGHTMAGENTA, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(YELLOW, YELLOW), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_RGB_COLOR, RGB_YELLOW, RGB_YELLOW, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(WHITE, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_RGB_COLOR, RGB_WHITE, RGB_WHITE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK }
};
#else
char _dialogSize[256];

static UI_PALETTE __colorMap[16] =
{
	{ ' ', attrib(BLACK, BLACK), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLACK, BLACK, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(BLUE, BLUE), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BLUE, BLUE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(GREEN, GREEN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, GREEN, GREEN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(CYAN, CYAN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, CYAN, CYAN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(RED, RED), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, RED, RED, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(MAGENTA, MAGENTA), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, MAGENTA, MAGENTA, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(BROWN, BROWN), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, BROWN, BROWN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTGRAY, LIGHTGRAY), attrib(MONO_BLACK, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGRAY, LIGHTGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(DARKGRAY, DARKGRAY), attrib(MONO_DIM, MONO_DIM),
		PTN_SOLID_FILL, DARKGRAY, DARKGRAY, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTBLUE, LIGHTBLUE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTBLUE, LIGHTBLUE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTGREEN, LIGHTGREEN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTGREEN, LIGHTGREEN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTCYAN, LIGHTCYAN), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTCYAN, LIGHTCYAN, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTRED, LIGHTRED), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTRED, LIGHTRED, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(LIGHTMAGENTA, LIGHTMAGENTA), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, LIGHTMAGENTA, LIGHTMAGENTA, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(YELLOW, YELLOW), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, YELLOW, YELLOW, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK },
	{ ' ', attrib(WHITE, WHITE), attrib(MONO_NORMAL, MONO_BLACK),
		PTN_SOLID_FILL, WHITE, WHITE, BW_BLACK, BW_BLACK, GS_BLACK, GS_BLACK }
};
#endif

UI_PALETTE *UI_DISPLAY::backgroundPalette = &__backgroundPalette;
UI_PALETTE *UI_DISPLAY::xorPalette = &__xorPalette;
UI_PALETTE *UI_DISPLAY::colorMap = __colorMap;

