## Zinc Interface Library version 3.00 makefile
## ZIL.LIB, ZILW.LIB, ZILWD.DLL, ZILWD.LIB,
## COPYRIGHT (C) 1990-1992.  All Rights Reserved.
## Zinc Software Incorporated.  Pleasant Grove, Utah  USA

## Uses Borland C++ 2.00

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bccx
LINK=tlinkx
LIBRARIAN=tlib
DOS_CPP_OPTS=-c -ml -O -V -Y -w -H=ZIL.SYM
DOS_LINK_OPTS=/c /x
DOS_LIB_OPTS=/C
WIN_CPP_OPTS=-c -ml -O -Vf -WE -w -H=ZIL.SYM
WIN_LINK_OPTS=/c /C /Twe /x
WIN_LIB_OPTS=/C
WINDLL_CPP_OPTS=-c -ml -O -Vf -WDE -w -H=ZIL.SYM
WINDLL_LINK_OPTS=/c /C /Twd /x
WINDLL_LIB_OPTS=/C
INCLUDE_DIR=.

## Libraries:
DOS_OBJS=c0l
DOS_LIBS=zil mathl emu graphics cl
WIN_OBJS=c0wl
WIN_LIBS=zilw import mathl cwinl
WINDLL_OBJS=c0dl
WINDLL_LIBS=import mathl cwinl cl


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) -I$(INCLUDE_DIR) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obw {$< }

.cpp.obd:
	$(CPP) $(WINDLL_CPP_OPTS) -I$(INCLUDE_DIR) -o$*.obd {$< }

.rc.res:
	rc -r $<


lib: zil.lib zilw.lib zilwd.dll


zil.lib: txtdsp.obj bgidsp.obj g_bgidsp.obj small.obj dialog.obj system.obj \
	bignum.obj bignum1.obj bignum2.obj bitmap.obj border.obj \
	button.obj combo.obj country.obj cursor.obj date.obj \
	date1.obj device.obj display.obj error.obj event.obj \
	fmtstr.obj group.obj help.obj hlist.obj icon.obj \
	int.obj keybrd.obj list.obj listblk.obj map1.obj \
	map2.obj max.obj min.obj mouse.obj path.obj \
	plldn.obj plldn1.obj popup.obj popup1.obj prompt.obj \
	real.obj region.obj scroll.obj store.obj store1.obj \
	string.obj sys.obj text.obj time.obj time1.obj title.obj \
	toolbar.obj vlist.obj win.obj win1.obj win2.obj \
	g_bignum.obj g_border.obj g_cursor.obj g_date.obj g_date1.obj \
	g_device.obj g_disp.obj g_event.obj g_hotkey.obj g_jump.obj \
	g_keybrd.obj g_proc.obj g_store.obj g_pnorm.obj g_phelp.obj \
	g_perror.obj g_time.obj g_time1.obj g_win1.obj g_win2.obj
	@del $*
	$(LIBRARIAN) $(DOS_LIB_OPTS) @&&!
$* &
+txtdsp+bgidsp.obj+g_bgidsp.obj+small.obj+dialog.obj+system.obj &
+bignum.obj+bignum1.obj+bignum2.obj+bitmap.obj+border.obj &
+button.obj+combo.obj+country.obj+cursor.obj+date.obj &
+date1.obj+device.obj+display.obj+error.obj+event.obj &
+fmtstr.obj+group.obj+help.obj+hlist.obj+icon.obj &
+int.obj+keybrd.obj+list.obj+listblk.obj+map1.obj &
+map2.obj+max.obj+min.obj+mouse.obj+path.obj &
+plldn.obj+plldn1.obj+popup.obj+popup1.obj+prompt.obj &
+real.obj+region.obj+scroll.obj+store.obj+store1.obj &
+string.obj+sys.obj+text.obj+time.obj+time1.obj+title.obj &
+toolbar.obj+vlist.obj+win.obj+win1.obj+win2.obj &
+g_bignum.obj+g_border.obj+g_cursor.obj+g_date.obj+g_date1.obj &
+g_device.obj+g_disp.obj+g_event.obj+g_hotkey.obj+g_jump.obj &
+g_keybrd.obj+g_proc.obj+g_store.obj+g_pnorm.obj+g_phelp.obj &
+g_perror.obj+g_time.obj+g_time1.obj+g_win1.obj+g_win2.obj
!
	@del zil.sym


zilw.lib: windsp.obw g_windsp.obw \
	bignum.obw bignum1.obw bignum2.obw bitmap.obw border.obw \
	button.obw combo.obw country.obw cursor.obw date.obw \
	date1.obw device.obw display.obw error.obw event.obw \
	fmtstr.obw group.obw help.obw hlist.obw icon.obw \
	int.obw keybrd.obw list.obw listblk.obw map1.obw \
	map2.obw max.obw min.obw mouse.obw path.obw \
	plldn.obw plldn1.obw popup.obw popup1.obw prompt.obw \
	real.obw region.obw scroll.obw store.obw store1.obw \
	string.obw sys.obw text.obw time.obw time1.obw title.obw \
	toolbar.obw vlist.obw win.obw win1.obw win2.obw \
	g_bignum.obw g_border.obw g_cursor.obw g_date.obw g_date1.obw \
	g_device.obw g_disp.obw g_event.obw g_hotkey.obw g_jump.obw \
	g_keybrd.obw g_proc.obw g_store.obw g_pnorm.obw g_phelp.obw \
	g_perror.obw g_time.obw g_time1.obw g_win1.obw g_win2.obw
	@del $*
	$(LIBRARIAN) $(WIN_LIB_OPTS) @&&!
$* &
+windsp.obw+g_windsp.obw &
+bignum.obw+bignum1.obw+bignum2.obw+bitmap.obw+border.obw &
+button.obw+combo.obw+country.obw+cursor.obw+date.obw &
+date1.obw+device.obw+display.obw+error.obw+event.obw &
+fmtstr.obw+group.obw+help.obw+hlist.obw+icon.obw &
+int.obw+keybrd.obw+list.obw+listblk.obw+map1.obw &
+map2.obw+max.obw+min.obw+mouse.obw+path.obw &
+plldn.obw+plldn1.obw+popup.obw+popup1.obw+prompt.obw &
+real.obw+region.obw+scroll.obw+store.obw+store1.obw &
+string.obw+sys.obw+text.obw+time.obw+time1.obw+title.obw &
+toolbar.obw+vlist.obw+win.obw+win1.obw+win2.obw &
+g_bignum.obw+g_border.obw+g_cursor.obw+g_date.obw+g_date1.obw &
+g_device.obw+g_disp.obw+g_event.obw+g_hotkey.obw+g_jump.obw &
+g_keybrd.obw+g_proc.obw+g_store.obw+g_pnorm.obw+g_phelp.obw &
+g_perror.obw+g_time.obw+g_time1.obw+g_win1.obw+g_win2.obw
!
	@del zil.sym


zilwd.dll: zilwd.res libmain.obd windsp.obd g_windsp.obd \
	bignum.obd bignum1.obd bignum2.obd bitmap.obd border.obd \
	button.obd combo.obd country.obd cursor.obd date.obd \
	date1.obd device.obd display.obd error.obd event.obd \
	fmtstr.obd group.obd help.obd hlist.obd icon.obd \
	int.obd keybrd.obd list.obd listblk.obd map1.obd \
	map2.obd max.obd min.obd mouse.obd path.obd \
	plldn.obd plldn1.obd popup.obd popup1.obd prompt.obd \
	real.obd region.obd scroll.obd store.obd store1.obd \
	string.obd sys.obd text.obd time.obd time1.obd title.obd \
	toolbar.obd vlist.obd win.obd win1.obd win2.obd \
	g_bignum.obd g_border.obd g_cursor.obd g_date.obd g_date1.obd \
	g_device.obd g_disp.obd g_event.obd g_hotkey.obd g_jump.obd \
	g_keybrd.obd g_proc.obd g_store.obd g_pnorm.obd g_phelp.obd \
	g_perror.obd g_time.obd g_time1.obd g_win1.obd g_win2.obd
	@del $*
	$(LINK) $(WINDLL_LINK_OPTS) @&&!
$(WINDLL_OBJS)+libmain.obd+windsp.obd+g_windsp.obd+
bignum.obd+bignum1.obd+bignum2.obd+bitmap.obd+border.obd+
button.obd+combo.obd+country.obd+cursor.obd+date.obd+
date1.obd+device.obd+display.obd+error.obd+event.obd+
fmtstr.obd+group.obd+help.obd+hlist.obd+icon.obd+
int.obd+keybrd.obd+list.obd+listblk.obd+map1.obd+
map2.obd+max.obd+min.obd+mouse.obd+path.obd+
plldn.obd+plldn1.obd+popup.obd+popup1.obd+prompt.obd+
real.obd+region.obd+scroll.obd+store.obd+store1.obd+
string.obd+sys.obd+text.obd+time.obd+time1.obd+title.obd+
toolbar.obd+vlist.obd+win.obd+win1.obd+win2.obd+
g_bignum.obd+g_border.obd+g_cursor.obd+g_date.obd+g_date1.obd+
g_device.obd+g_disp.obd+g_event.obd+g_hotkey.obd+g_jump.obd+
g_keybrd.obd+g_proc.obd+g_store.obd+g_pnorm.obd+g_phelp.obd+
g_perror.obd+g_time.obd+g_time1.obd+g_win1.obd+g_win2.obd
$*, , $(WINDLL_LIBS)
$*.def
!
	rc $*.res $*.dll
	implib $*.lib $*.dll
	@del zil.sym
