//	Zinc Interface Library - PATH.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#if defined(__ZTC__) | defined(_MSC_VER)
#include <direct.h>
#else
#include <dir.h>
#endif
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include "ui_gen.hpp"
#pragma hdrstop

static UI_PATH path;
UI_PATH *_path = &path;

// ----- UI_PATH_ELEMENT & UI_PATH ------------------------------------------

UI_PATH_ELEMENT::UI_PATH_ELEMENT(char *_pathName, int length)
{
	if (length == -1)
		length = ui_strlen(_pathName);
	pathName = new char[length+1];
	strncpy(pathName, _pathName, length);
	pathName[length] = '\0';
}

UI_PATH_ELEMENT::~UI_PATH_ELEMENT(void)
{
	delete pathName;
}

UI_PATH::UI_PATH(char *programPath, int rememberCWD)
{
	// Get the path names.
	char path[256];
	if (rememberCWD)				// The current working directory.
	{
		getcwd(path, 256);
//		char *endPath = strrchr(path, '\\');
//		if (endPath)
//		{
//			if (endPath > path && *(endPath - 1) == ':')
//				endPath++;			// Leave in the slash if root dir.
//			*endPath = '\0';
//		}
		Add(NULL, new UI_PATH_ELEMENT(path));
	}

	if (programPath)				// The program path.
	{
		strcpy(path, programPath);
		char *endPath = strrchr(path, '\\');
		if (endPath)
		{
			if (endPath > path && *(endPath - 1) == ':')
				endPath++;			// Leave in the slash if root dir.
			*endPath = '\0';
		}
		Add(NULL, new UI_PATH_ELEMENT(path));
	}

	if (getenv("ZINC_PATH"))		// The zinc path.
	{
		strcpy(path, getenv("ZINC_PATH"));
		for (int i = 0; path[i]; )	// Parse the directory tree.
		{
			for (int j = i; path[j] && path[j] != ';'; )
				j++;
			Add(NULL, new UI_PATH_ELEMENT(&path[i], j - i));
			i = path[j] ? j + 1 : j;
		}
	}

	if (getenv("PATH"))				// The environment path.
	{
		strcpy(path, getenv("PATH"));
		for (int i = 0; path[i]; )	// Parse the directory tree.
		{
			for (int j = i; path[j] && path[j] != ';'; )
				j++;
			Add(NULL, new UI_PATH_ELEMENT(&path[i], j - i));
			i = path[j] ? j + 1 : j;
		}
	}
}

UI_PATH::~UI_PATH(void)
{
	if (_path == this)
		_path = NULL;
}
