//	Zinc Interface Library - PLLDN1.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"
#pragma hdrstop
const int ITEM_OFFSET = 4;	// Constant value used in DrawItem().

// ----- UIW_PULL_DOWN_ITEM -------------------------------------------------

UIW_PULL_DOWN_ITEM::UIW_PULL_DOWN_ITEM(char *_text, WNF_FLAGS _wnFlags,
	USER_FUNCTION _userFunction, EVENT_TYPE _value) :
	UIW_BUTTON(0, 0, ui_strlen(_text), _text,
	BTF_DOWN_CLICK | BTF_NO_TOGGLE | BTF_NO_3D, WOF_JUSTIFY_CENTER,
	_userFunction, _value),
	menu(0, 0, _wnFlags, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY)
{
	// Initialize the menu item information.
	UIW_PULL_DOWN_ITEM::Information(INITIALIZE_CLASS, NULL);
}

UIW_PULL_DOWN_ITEM::UIW_PULL_DOWN_ITEM(char *_text, WNF_FLAGS _wnFlags,
	UI_ITEM *item) :
	UIW_BUTTON(0, 0, ui_strlen(_text), _text,
	BTF_DOWN_CLICK | BTF_NO_TOGGLE | BTF_NO_3D, WOF_JUSTIFY_CENTER),
	menu(0, 0, _wnFlags, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY)
{
	// Initialize the menu information.
	UIW_PULL_DOWN_ITEM::Information(INITIALIZE_CLASS, NULL);

	// Add the pop-up menu items.
	for (int i = 0; item[i].text; i++)
		Add(new UIW_POP_UP_ITEM(item[i].text, item[i].flags, BTF_NO_3D,
			WOF_NO_FLAGS, (USER_FUNCTION)item[i].data, item[i].value));
}

UIW_PULL_DOWN_ITEM::~UIW_PULL_DOWN_ITEM(void)
{
}

#ifdef _WINDOWS
EVENT_TYPE UIW_PULL_DOWN_ITEM::DrawItem(const UI_EVENT &, EVENT_TYPE ccode)
{
	return (ccode);
}

EVENT_TYPE UIW_PULL_DOWN_ITEM::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		UI_WINDOW_OBJECT::Event(event);
		if (menu.First())
		{
			menu.Event(event);
			WORD wFlags = MF_STRING | MF_POPUP;
			if (FlagSet(woFlags, WOF_NON_SELECTABLE))
				wFlags |= MF_GRAYED;
			AppendMenu(parent->screenID, wFlags, menu.screenID, text);
		}
		else
		{
			WORD wFlags = MF_STRING;
			if (FlagSet(woFlags, WOF_NON_SELECTABLE))
				wFlags |= MF_GRAYED;
			AppendMenu(parent->screenID, wFlags, numberID, text);
		}
		break;

	case S_DEINITIALIZE:
		if (parent->screenID)
			DeleteMenu(parent->screenID, numberID, MF_BYCOMMAND);
		break;

	case S_ADD_OBJECT:
	case S_SUBTRACT_OBJECT:
		menu.Event(event);
		break;

	default:
		if (ccode == L_SELECT)
			ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#else
EVENT_TYPE UIW_PULL_DOWN_ITEM::DrawItem(const UI_EVENT &, EVENT_TYPE ccode)
{
	// Draw the string.
	UI_REGION region = true;
	if (FlagSet(woFlags, WOF_BORDER))
		DrawBorder(screenID, region, FALSE, ccode);
	display->Rectangle(screenID, region, lastPalette, 0, TRUE, FALSE, &clip);
	if (!display->isText)
		region.left += ITEM_OFFSET;
	DrawText(screenID, region, text, lastPalette, FALSE, ccode);
	return (ccode);
}

EVENT_TYPE UIW_PULL_DOWN_ITEM::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_PULL_DOWN_ITEM);
	switch (ccode)
	{
	case S_INITIALIZE:
		UI_WINDOW_OBJECT::Event(event);
		relative.right = relative.left + display->TextWidth(text, screenID, font) + 2 * display->cellWidth - 1;
		break;

	case S_ADD_OBJECT:
	case S_SUBTRACT_OBJECT:
		menu.Event(event);
		break;

	case S_CURRENT:
	case S_NON_CURRENT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		UI_WINDOW_OBJECT::Event(event);
		if (FlagSet(woStatus, WOS_REDISPLAY))
		{
			DrawItem(event, ccode);
			woStatus &= ~WOS_REDISPLAY;
		}
		break;

	case L_BEGIN_SELECT:
		ccode = UI_WINDOW_OBJECT::Event(event);
		if (ccode == S_UNKNOWN)
			break;
		// Continue to L_SELECT.
	case L_SELECT:
	case L_UP:
	case L_DOWN:
		if (userFunction)
		{
			UI_EVENT uEvent;
			uEvent = event;
			ccode = (*userFunction)(this, uEvent, L_SELECT);
		}
		else if (menu.First() && windowManager->Index(&menu) == -1)
		{
	 		menu.RegionConvert(menu.relative, TRUE);
			menu.relative.left = true.left;
			menu.relative.top = true.bottom + 1;
			if (menu.Current())
				menu.Current()->woStatus &= ~WOS_CURRENT;
			if (menu.First())
				menu.First()->woStatus |= WOS_CURRENT;
			*windowManager + &menu;
		}
		break;

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_PULL_DOWN_ITEM::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_PULL_DOWN_ITEM;
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_PULL_DOWN_ITEM;
		windowID[1] = ID_MENU_ITEM;
		windowID[2] = ID_BUTTON;
		font = FNT_SYSTEM_FONT;
		menu.parent = this;
		break;

	case CHANGED_FLAGS:
#ifdef _WINDOWS
		if (parent && parent->screenID)
		{
			int position = 0;
			for (UI_WINDOW_OBJECT *object = Previous(); object; object = object->Previous())
				position++;
			WORD wFlags = MF_BYPOSITION;
			if (FlagSet(woFlags, WOF_NON_SELECTABLE))
				wFlags |= MF_GRAYED;
			else
				wFlags |= MF_ENABLED;
			EnableMenuItem(parent->screenID, position, wFlags);
		}
#endif
		break;

	case GET_NUMBERID_OBJECT:
	case GET_STRINGID_OBJECT:
		{
		void *match = UI_WINDOW_OBJECT::Information(request, data, objectID);
		if (!match)
			match = menu.Information(request, data, objectID);
		data = match;
		}
		break;

	case PRINT_INFORMATION:
	case PRINT_USER_FUNCTION:
		UI_WINDOW_OBJECT::Information(request, data, objectID);
		menu.Information(request, data, objectID);
		break;

	default:
		data = UIW_BUTTON::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_PULL_DOWN_ITEM::UIW_PULL_DOWN_ITEM(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_BUTTON(0, 0, 10, NULL, BTF_DOWN_CLICK | BTF_NO_TOGGLE | BTF_NO_3D,
	WOF_JUSTIFY_CENTER),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY)
{
	// Initialize the pull-down item information.
	UIW_PULL_DOWN_ITEM::Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_BUTTON::Information(INITIALIZE_CLASS, NULL);
	UIW_PULL_DOWN_ITEM::Information(INITIALIZE_CLASS, NULL);
	UIW_BUTTON::DataSet(text);
}

void UIW_PULL_DOWN_ITEM::Load(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Read the file information.
	UIW_BUTTON::Load(name, directory, file);
	menu.Load(NULL, directory, file);
}

void UIW_PULL_DOWN_ITEM::Store(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Store the pull-down item information.
	UIW_BUTTON::Store(name, directory, file);
	menu.Store(NULL, directory, file);
}
#endif

