//	Zinc Interface Library - POPUP1.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <string.h>
#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_POP_UP_ITEM ----------------------------------------------------

UIW_POP_UP_ITEM::UIW_POP_UP_ITEM(void) :
	UIW_BUTTON(0, 0, 1, NULL, BTF_NO_3D, WOF_NO_FLAGS),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY),
	mniFlags(MNIF_SEPARATOR)
{
	// Initialize the pull-down item seperator information.
	UIW_POP_UP_ITEM::Information(INITIALIZE_CLASS, NULL);
}

UIW_POP_UP_ITEM::UIW_POP_UP_ITEM(char *_text, MNIF_FLAGS _mniFlags,
	BTF_FLAGS _btFlags, WOF_FLAGS _woFlags, USER_FUNCTION _userFunction,
	EVENT_TYPE _value) :
	UIW_BUTTON(0, 0, 0, _text, _btFlags, _woFlags, _userFunction, _value),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY),
	mniFlags(_mniFlags)
{
	// Initialize the pull-down item information.
	UIW_POP_UP_ITEM::Information(INITIALIZE_CLASS, NULL);
}

UIW_POP_UP_ITEM::UIW_POP_UP_ITEM(int left, int top, int width, char *_text,
	MNIF_FLAGS _mniFlags, BTF_FLAGS _btFlags, WOF_FLAGS _woFlags,
	USER_FUNCTION _userFunction, EVENT_TYPE _value) :
	UIW_BUTTON(left, top, width, _text, _btFlags, _woFlags, _userFunction, _value),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY),
	mniFlags(_mniFlags)
{
	// Initialize the pull-down item information.
	UIW_POP_UP_ITEM::Information(INITIALIZE_CLASS, NULL);
}

UIW_POP_UP_ITEM::~UIW_POP_UP_ITEM(void)
{
}

#ifdef _WINDOWS
EVENT_TYPE UIW_POP_UP_ITEM::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
		UI_WINDOW_OBJECT::Event(event);
		// Continue to S_CREATE.
	case S_CREATE:
		if (menu.First())
		{
			menu.Event(event);
			WORD wFlags = MF_STRING | MF_POPUP;
			if (FlagSet(woFlags, WOF_NON_SELECTABLE))
				wFlags |= MF_GRAYED;
			else if (FlagSet(mniFlags, MNIF_CHECK_MARK) && FlagSet(woStatus, WOS_SELECTED))
				wFlags |= MF_CHECKED;
			AppendMenu(parent->screenID, wFlags, menu.screenID, text);
		}
		else
		{
			WORD tNumberID = numberID;
			if (FlagSet(mniFlags, MNIF_RESTORE))
				tNumberID = SC_RESTORE;
			else if (FlagSet(mniFlags, MNIF_MOVE))
				tNumberID = SC_MOVE;
			else if (FlagSet(mniFlags, MNIF_SIZE))
				tNumberID = SC_SIZE;
			else if (FlagSet(mniFlags, MNIF_MINIMIZE))
				tNumberID = SC_MINIMIZE;
			else if (FlagSet(mniFlags, MNIF_MAXIMIZE))
				tNumberID = SC_MAXIMIZE;
			else if (FlagSet(mniFlags, MNIF_CLOSE))
				tNumberID = SC_CLOSE;
			else if (FlagSet(mniFlags, MNIF_SWITCH))
				tNumberID = SC_TASKLIST;
			WORD wFlags = MF_STRING;
			if (FlagSet(mniFlags, MNIF_SEPARATOR))
				wFlags = MF_SEPARATOR;
			else if (FlagSet(woFlags, WOF_NON_SELECTABLE))
				wFlags |= MF_GRAYED;
			else if (FlagSet(mniFlags, MNIF_CHECK_MARK) && FlagSet(woStatus, WOS_SELECTED))
				wFlags |= MF_CHECKED;
			AppendMenu(parent->screenID, wFlags, tNumberID, text);
		}
		break;

	case S_DEINITIALIZE:
		if (parent->screenID)
		{
			WORD tNumberID = numberID;
			if (FlagSet(mniFlags, MNIF_RESTORE))
				tNumberID = SC_RESTORE;
			else if (FlagSet(mniFlags, MNIF_MOVE))
				tNumberID = SC_MOVE;
			else if (FlagSet(mniFlags, MNIF_SIZE))
				tNumberID = SC_SIZE;
			else if (FlagSet(mniFlags, MNIF_MINIMIZE))
				tNumberID = SC_MINIMIZE;
			else if (FlagSet(mniFlags, MNIF_MAXIMIZE))
				tNumberID = SC_MAXIMIZE;
			else if (FlagSet(mniFlags, MNIF_CLOSE))
				tNumberID = SC_CLOSE;
			else if (FlagSet(mniFlags, MNIF_SWITCH))
				tNumberID = SC_TASKLIST;
			DeleteMenu(parent->screenID, tNumberID, MF_BYCOMMAND);
		}
		break;

	case S_ADD_OBJECT:
	case S_SUBTRACT_OBJECT:
		menu.Event(event);
		break;

	default:
		if (ccode == L_SELECT)
			ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#else
const int ITEM_OFFSET = 4;

EVENT_TYPE UIW_POP_UP_ITEM::DrawItem(const UI_EVENT &, EVENT_TYPE ccode)
{
	// Draw the pop-up item.
	UI_REGION region = true;
	if (FlagSet(woFlags, WOF_BORDER))
		DrawBorder(screenID, region, FALSE, ccode);
	display->Rectangle(screenID, region, lastPalette, 0, TRUE, FALSE, &clip);
	if (FlagSet(mniFlags, MNIF_SEPARATOR))
	{
		lastPalette = LogicalPalette(S_DISPLAY_ACTIVE, ID_OUTLINE);
		region.top = (region.top + region.bottom) / 2;
		display->Line(screenID, region.left, region.top, region.right,
			region.top, lastPalette, 1, FALSE, &clip);
		return (ccode);
	}
	if (!display->isText)
		region.left += ITEM_OFFSET;

	// Draw the check mark.
	COLOR foregroundColor = display->MapColor(lastPalette, TRUE);
	if (!FlagSet(woStatus, WOS_SELECTED) || !FlagSet(mniFlags, MNIF_CHECK_MARK))
		;
	else if (display->isText)
		display->Text(screenID, region.left, region.top, "*", lastPalette, 1, FALSE, FALSE, &clip);
	else
	{
		static UCHAR checkMark[90] =
		{
			BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND, BACKGROUND, BACKGROUND, BACKGROUND, BLACK,
			BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND, BACKGROUND, BACKGROUND, BACKGROUND, BLACK,
			BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND, BACKGROUND, BACKGROUND, BLACK, 		BLACK,
			BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND, BACKGROUND, BACKGROUND, BLACK, 		BACKGROUND,
			BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND, BACKGROUND, BLACK, 		BLACK, 		BACKGROUND,
			BACKGROUND,	BLACK,		BACKGROUND,	BACKGROUND,	BACKGROUND, BACKGROUND, BLACK, 		BACKGROUND, BACKGROUND,
			BLACK,		BLACK,		BLACK,		BACKGROUND,	BACKGROUND, BLACK, 		BLACK, 		BACKGROUND, BACKGROUND,
			BACKGROUND,	BACKGROUND,	BLACK,		BLACK,		BACKGROUND, BLACK, 		BACKGROUND, BACKGROUND, BACKGROUND,
			BACKGROUND,	BACKGROUND,	BACKGROUND,	BLACK,		BLACK, 		BLACK, 		BACKGROUND, BACKGROUND, BACKGROUND,
			BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,	BLACK,		BACKGROUND, BACKGROUND, BACKGROUND, BACKGROUND
		};
		for (int i = 0; i < 90; i++)
			if (checkMark[i] != BACKGROUND)
				checkMark[i] = foregroundColor;
		int top = true.top + (true.bottom - true.top - 10) / 2;
		display->Bitmap(screenID, region.left, top, 9, 10, checkMark, NULL, &clip);
	}
	region.left += display->cellWidth;

	// Draw the string.
	DrawText(screenID, region, text, lastPalette, FALSE, ccode);

	// Draw the right arrow.
	if (menu.First() && display->isText)
		display->Text(screenID, region.right, region.top, "", lastPalette, 1, FALSE, FALSE, &clip);
	else if (menu.First())
	{
		static UCHAR rightArrow[45] =
		{
			BLACK,		BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND,
			BLACK,		BLACK,		BACKGROUND,	BACKGROUND,	BACKGROUND,
			BLACK,		BLACK,		BLACK,		BACKGROUND,	BACKGROUND,
			BLACK,		BLACK,		BLACK,		BLACK,		BACKGROUND,
			BLACK,		BLACK,		BLACK,		BLACK,		BLACK,
			BLACK,		BLACK,		BLACK,		BLACK,		BACKGROUND,
			BLACK,		BLACK,		BLACK,		BACKGROUND,	BACKGROUND,
			BLACK,		BLACK,		BACKGROUND,	BACKGROUND,	BACKGROUND,
			BLACK,		BACKGROUND,	BACKGROUND,	BACKGROUND,	BACKGROUND
		};
		for (int i = 0; i < 45; i++)
			if (rightArrow[i] != BACKGROUND)
				rightArrow[i] = foregroundColor;
		region.left = true.right - 2 * ITEM_OFFSET;
		region.top = true.top + (true.bottom - true.top - 9) / 2;
		display->Bitmap(screenID, region.left, region.top, 5, 9, rightArrow, NULL, &clip);
	}

	return (ccode);
}

EVENT_TYPE UIW_POP_UP_ITEM::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_POP_UP_ITEM);
	switch (ccode)
	{
	case S_INITIALIZE:
		UI_WINDOW_OBJECT::Event(event);
		if (FlagSet(mniFlags, MNIF_SEPARATOR))
		{
			woFlags |= WOF_NON_SELECTABLE;
			relative.right = relative.left;
			relative.bottom = relative.top + display->cellHeight / 2;
		}
		else if (display->isText)
		{
 			relative.right = relative.left + display->TextWidth(text, screenID, font) + 1;
			if (menu.First())
				relative.right += 4;
 			relative.bottom = relative.top;
		}
		else
		{
 			relative.right = relative.left + display->TextWidth(text, screenID, font) + display->cellHeight;
			if (menu.First())
				relative.right += display->cellHeight;
 			relative.bottom = relative.top + display->cellHeight - display->preSpace - display->postSpace - 1;
		}
		break;

	case S_CURRENT:
	case S_NON_CURRENT:
	case S_DISPLAY_ACTIVE:
	case S_DISPLAY_INACTIVE:
		UI_WINDOW_OBJECT::Event(event);
		if (FlagSet(woStatus, WOS_REDISPLAY))
		{
			DrawItem(event, ccode);
			woStatus &= ~WOS_REDISPLAY;
		}
		break;

	case S_ADD_OBJECT:
	case S_SUBTRACT_OBJECT:
		menu.Event(event);
		break;

	case L_END_SELECT:
		if (!true.Overlap(event.position) || !FlagSet(btStatus, BTS_DEPRESSED))
			return (UIW_BUTTON::Event(event));
		ccode = L_SELECT;
		// Continue to L_END_SELECT.
	case L_SELECT:
	case L_LEFT:
	case L_RIGHT:
		if (ccode == L_SELECT && menu.First() && windowManager->Index(&menu) != -1)
			break;
		else if ((ccode == L_RIGHT || ccode == L_SELECT) && menu.First())
		{
	 		menu.RegionConvert(menu.relative, TRUE);
			menu.relative.left = true.right - 2 * ITEM_OFFSET;
			menu.relative.top = true.top - 1;
			if (menu.Current())
				menu.Current()->woStatus &= ~WOS_CURRENT;
			if (menu.First())
				menu.First()->woStatus |= WOS_CURRENT;
			*windowManager + &menu;
		}
		else if (ccode == L_SELECT)
		{
			ccode = UIW_BUTTON::Event(event);
			for (UI_WINDOW_OBJECT *object = windowManager->First();
				object && FlagSet(object->woAdvancedFlags, WOAF_TEMPORARY);
				object = windowManager->First())
				windowManager->Event(UI_EVENT(S_CLOSE_TEMPORARY));
		}
		else if (ccode == L_LEFT && parent->parent &&
			parent->parent->Inherited(ID_POP_UP_ITEM))
			windowManager->Event(UI_EVENT(S_CLOSE_TEMPORARY));
		else
		{
			for (UI_WINDOW_OBJECT *object = windowManager->First();
				object && FlagSet(object->woAdvancedFlags, WOAF_TEMPORARY);
				object = windowManager->First())
				windowManager->Event(UI_EVENT(S_CLOSE_TEMPORARY));
			eventManager->Put(UI_EVENT(ccode));
			eventManager->Put(UI_EVENT(L_DOWN));
		}
		break;

	default:
		ccode = UIW_BUTTON::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_POP_UP_ITEM::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	// Switch on the request.
	if (!objectID) objectID = ID_POP_UP_ITEM;
	switch (request)
	{
	case INITIALIZE_CLASS:
		// Initialize the class information.
		searchID = windowID[0] = ID_POP_UP_ITEM;
		windowID[1] = ID_MENU_ITEM;
		windowID[2] = ID_BUTTON;
		font = FNT_SYSTEM_FONT;
		menu.parent = this;
		// Continue to CHANGED_FLAGS.
	case CHANGED_FLAGS:
		woFlags &= ~WOF_BORDER;
		btFlags |= BTF_NO_3D;
		// Check the flags with the number identifications.
		if (FlagSet(mniFlags, MNIF_RESTORE))
			numberID = NUMID_OPT_RESTORE;
		else if (FlagSet(mniFlags, MNIF_MOVE))
			numberID = NUMID_OPT_MOVE;
		else if (FlagSet(mniFlags, MNIF_SIZE))
			numberID = NUMID_OPT_SIZE;
		else if (FlagSet(mniFlags, MNIF_MINIMIZE))
			numberID = NUMID_OPT_MINIMIZE;
		else if (FlagSet(mniFlags, MNIF_MAXIMIZE))
			numberID = NUMID_OPT_MAXIMIZE;
		else if (FlagSet(mniFlags, MNIF_CLOSE))
			numberID = NUMID_OPT_CLOSE;
		else if (FlagSet(mniFlags, MNIF_SWITCH))
			numberID = NUMID_OPT_SWITCH;
		// Check for system commands
		if (FlagSet(mniFlags, 0x00FF))
		{
			btFlags |= BTF_SEND_MESSAGE;
			if (FlagSet(mniFlags, MNIF_RESTORE))
				value = L_RESTORE;
			else if (FlagSet(mniFlags, MNIF_MOVE))
				value = L_MOVE;
  			else if (FlagSet(mniFlags, MNIF_SIZE))
				value = L_SIZE;
			else if (FlagSet(mniFlags, MNIF_MINIMIZE))
				value = L_MINIMIZE;
			else if (FlagSet(mniFlags, MNIF_MAXIMIZE))
				value = L_MAXIMIZE;
			else if (FlagSet(mniFlags, MNIF_CLOSE))
				value = S_CLOSE;
		}
		if ((FlagSet(btFlags, BTF_SEND_MESSAGE) || FlagSet(mniFlags, MNIF_SEND_MESSAGE)) &&
			!userFunction)
		{
			btFlags |= BTF_SEND_MESSAGE;
			mniFlags |= MNIF_SEND_MESSAGE;
			userFunction = &UIW_BUTTON::Message;
		}
		if (!text || text[0] == '\0')
			mniFlags = MNIF_SEPARATOR;
		if (FlagSet(mniFlags, MNIF_NON_SELECTABLE))
			woFlags |= WOF_NON_SELECTABLE;
#ifdef _WINDOWS
		if (request == CHANGED_FLAGS && parent && parent->screenID)
		{
			int position = 0;
			for (UI_WINDOW_OBJECT *object = Previous(); object; object = object->Previous())
				position++;
			WORD wFlags = MF_BYPOSITION;
			if (FlagSet(woFlags, WOF_NON_SELECTABLE))
				wFlags |= MF_GRAYED;
			else
				wFlags |= MF_ENABLED;
			EnableMenuItem(parent->screenID, position, wFlags);
			if (FlagSet(mniFlags, MNIF_CHECK_MARK))
			{
				WORD wFlags = MF_BYPOSITION;
				if (FlagSet(woStatus, WOS_SELECTED))
					wFlags |= MF_CHECKED;
				else
					wFlags |= MF_UNCHECKED;
				EnableMenuItem(parent->screenID, position, wFlags);
			}
		}
#endif
		break;

	case GET_NUMBERID_OBJECT:
	case GET_STRINGID_OBJECT:
		{
		void *match = UI_WINDOW_OBJECT::Information(request, data, objectID);
		if (!match)
			match = menu.Information(request, data, objectID);
		data = match;
		}
		break;

	case GET_FLAGS:
	case SET_FLAGS:
	case CLEAR_FLAGS:
		if (objectID && objectID != ID_POP_UP_ITEM)
			data = UIW_BUTTON::Information(request, data, objectID);
		else if (request == GET_FLAGS && !data)
			data = &mniFlags;
		else if (request == GET_FLAGS)
			*(MNIF_FLAGS *)data = mniFlags;
		else if (request == SET_FLAGS)
			mniFlags |= *(MNIF_FLAGS *)data;
		else
			mniFlags &= ~(*(MNIF_FLAGS *)data);
		break;

	case PRINT_INFORMATION:
	case PRINT_USER_FUNCTION:
		UI_WINDOW_OBJECT::Information(request, data, objectID);
		menu.Information(request, data, objectID);
		break;

	default:
		data = UIW_BUTTON::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_POP_UP_ITEM::UIW_POP_UP_ITEM(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_BUTTON(0, 0, 1, NULL, BTF_NO_3D, WOF_NO_FLAGS),
	menu(0, 0, WNF_NO_FLAGS, WOF_BORDER, WOAF_TEMPORARY | WOAF_NO_DESTROY),
	mniFlags(MNIF_NO_FLAGS)
{
	// Initialize the pop-up item information.
	UIW_POP_UP_ITEM::Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_BUTTON::Information(INITIALIZE_CLASS, NULL);
	UIW_POP_UP_ITEM::Information(INITIALIZE_CLASS, NULL);
	UIW_BUTTON::DataSet(text);
}

void UIW_POP_UP_ITEM::Load(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Load the pop-up item information.
	UIW_BUTTON::Load(name, directory, file);
	file->Load(&mniFlags);
	menu.Load(NULL, directory, file);
}

void UIW_POP_UP_ITEM::Store(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Store the pop-up item information.
	UIW_BUTTON::Store(name, directory, file);
	file->Store(mniFlags);
	menu.Store(NULL, directory, file);
}
#endif

