//	Zinc Interface Library - STORE1.CPP
//	COPYRIGHT (C) 1990, 1991.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stdio.h>
#include <string.h>
#include "ui_gen.hpp"
#pragma hdrstop

#ifndef _WINDOWS
#define PrintStatus printf
#endif

void Z_GenerateHeaderFile(UI_STORAGE *directory, int printStatus)
{
	// Make sure there is an UI_HPP directory.
	if (directory->ChDir("~UI_HPP"))
		return;

	// Generate the HPP file.
	char line[256], fileName[256];
	directory->StorageName(fileName);
	UI_STORAGE::ChangeExtension(fileName, ".hpp");
#ifndef _WINDOWS
	if (printStatus)
		PrintStatus("GENERATING %s:\n", fileName);
#endif
	FILE *includeFile = fopen(fileName, "w+");
	for (char *entry = directory->FindFirstObject("*"); entry; entry = directory->FindNextObject())
		if (strcmp(entry, ".") && strcmp(entry, ".."))
		{
#ifndef _WINDOWS
			if (printStatus)
				PrintStatus("  USE_%s\n", entry);
#endif
			fprintf(includeFile, "#ifdef USE_%s\n", entry);
			UI_STORAGE_OBJECT hppEntry(*directory, entry, 0, UIS_READ);
			for (hppEntry.Load(line, 256); strcmp(line, ""); hppEntry.Load(line, 256))
				fprintf(includeFile, "%s\n", line);
			fprintf(includeFile, "#endif // USE_%s\n\n", entry);
		}
	fclose(includeFile);
}

