//	Zinc Interface Library - TOOLBAR.CPP
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include "ui_win.hpp"
#pragma hdrstop

// ----- UIW_TOOL_BAR -------------------------------------------------------

UIW_TOOL_BAR::UIW_TOOL_BAR(int left, int top, int width, int height,
	WNF_FLAGS _wnFlags, WOF_FLAGS _woFlags, WOAF_FLAGS _woAdvancedFlags) :
	UIW_WINDOW(left, top, width, height, _woFlags, _woAdvancedFlags)
{
	// Initialize the menu information.
	wnFlags |= _wnFlags;
	UIW_TOOL_BAR::Information(INITIALIZE_CLASS, NULL);
}

UIW_TOOL_BAR::~UIW_TOOL_BAR(void)
{
}

#ifdef _WINDOWS
static int _toolbarOffset = -1;
static FARPROC _toolbarCallback = (FARPROC)DefWindowProc;
static FARPROC _toolbarJumpInstance = NULL;

long FAR PASCAL _export ToolbarJumpProcedure(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
	UIW_TOOL_BAR *object = (UIW_TOOL_BAR *)GetWindowLong(hWnd, _toolbarOffset);
	return (object->Event(UI_EVENT(E_MSWINDOWS, hWnd, wMsg, wParam, lParam)));
}

EVENT_TYPE UIW_TOOL_BAR::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_TOOL_BAR);
	switch (ccode)
	{
	case S_INITIALIZE:
		if (!_toolbarJumpInstance)
			_toolbarJumpInstance = (FARPROC)ToolbarJumpProcedure;
		UIW_WINDOW::Event(event);
		break;

	case S_SIZE:
		if (!screenID || FlagSet(woStatus, WOS_INTERNAL_ACTION))
			break;
		// Continue to S_CREATE.
	case S_CREATE:
		{
		WOF_FLAGS _woFlags = woFlags;		// Get the remaining window region.
		woFlags |= WOF_NON_FIELD_REGION;
		UI_WINDOW_OBJECT::Event(event);
		woFlags = _woFlags;
		true.left--; true.right++;
		true.bottom = --true.top + relative.bottom - relative.top + 2;

		if (!FlagSet(wnFlags, WNF_NO_WRAP) && First())
		{
			int height = 1;
			for (object = First(); object; object = object->Next())
				if (height < object->relative.bottom - object->relative.top)
					height = object->relative.bottom - object->relative.top + 1;
			true.bottom = true.top + height - 1;
			relative.right = true.right - true.left;
			relative.bottom = true.bottom - true.top;
			int left = 0, top = 0;
			for (object = First(); object; object = object->Next())
			{
				int width = object->relative.right - object->relative.left + 1;
				if (left + width > relative.right)
				{
					left = 0;
					top += height;
					true.bottom += height;
				}
				object->relative.left = left;
				object->relative.top = top;
				left += width;
				object->relative.right = left - 1;
				object->relative.bottom = top + height - 1;
			}
			true.bottom += 2;
		}

		if (ccode == S_CREATE)
		{
			RegisterObject("UIW_TOOL_BAR", NULL, &_toolbarOffset,
				&_toolbarJumpInstance, &_toolbarCallback, NULL);
			for (object = First(); object; object = object->Next())
				object->Event(event);
		}
		else if (!FlagSet(wnFlags, WNF_NO_WRAP))
		{
			for (object = First(); object; object = object->Next())
			{
				UI_REGION region = object->true;
				object->Event(event);
				if (object->true != region)
					SetWindowPos(object->screenID, object->screenID,
						object->true.left, object->true.top,
						object->true.right - object->true.left + 1,
						object->true.bottom - object->true.top + 1,
						SWP_NOZORDER | SWP_NOREDRAW);
			}
		}
		}
		break;

	case L_PREVIOUS:
	case L_NEXT:
		ccode = S_UNKNOWN;
		break;

	case L_UP:
	case L_DOWN:
	case L_LEFT:
	case L_RIGHT:
		ccode = UIW_WINDOW::Event(UI_EVENT((ccode == L_LEFT || ccode == L_UP) ? L_PREVIOUS : L_NEXT));
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#else
EVENT_TYPE UIW_TOOL_BAR::Event(const UI_EVENT &event)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_TOOL_BAR);
	switch (ccode)
	{
	case S_SIZE:
	case S_CREATE:
		{
		clipList.Destroy();
		WOF_FLAGS _woFlags = woFlags;		// Get the remaining window region.
		woFlags |= WOF_NON_FIELD_REGION;
		UI_WINDOW_OBJECT::Event(event);
		woFlags = _woFlags;
		if (display->isText)
		{
			woFlags &= ~WOF_BORDER;
			true.bottom = true.top + relative.bottom - relative.top;
		}
		else
		{
			woFlags |= WOF_BORDER;
			true.left--; true.right++;
			true.bottom = --true.top + relative.bottom - relative.top + 2;
		}
		}
		if (!FlagSet(wnFlags, WNF_NO_WRAP) && First())
		{
			int height = 1;
			for (object = First(); object; object = object->Next())
				if (height < object->relative.bottom - object->relative.top)
					height = object->relative.bottom - object->relative.top + 1;
			true.bottom = true.top + height - 1;
			relative.right = true.right - true.left;
			relative.bottom = true.bottom - true.top;
			int left = 0, top = 0;
			for (object = First(); object; object = object->Next())
			{
				int width = object->relative.right - object->relative.left + 1;
				if (left + width > relative.right)
				{
					left = 0;
					top += height;
					true.bottom += height;
				}
				object->relative.left = left;
				object->relative.top = top;
				left += width;
				object->relative.right = left - 1;
				object->relative.bottom = top + height - 1;
			}
			if (!display->isText)
				true.bottom += 2;

			// Compute the actual regions.
			UI_REGION region = true;
			if (FlagSet(woFlags, WOF_BORDER))
				--region;
			clipList.Destroy();
			clipList.Add(new UI_REGION_ELEMENT(screenID, region));
			for (object = First(); object; object = object->Next())
				object->Event(event);
		}
		else
		{
			for (object = First(); object; object = object->Next())
				object->Event(event);
		}
		break;

	case L_PREVIOUS:
	case L_NEXT:
		ccode = S_UNKNOWN;
		break;

	case L_UP:
	case L_DOWN:
	case L_LEFT:
	case L_RIGHT:
		ccode = UIW_WINDOW::Event(UI_EVENT((ccode == L_LEFT || ccode == L_UP) ? L_PREVIOUS : L_NEXT));
		break;

	default:
		ccode = UIW_WINDOW::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
#endif

void *UIW_TOOL_BAR::Information(INFO_REQUEST request, void *data, OBJECTID objectID)
{
	UI_WINDOW_OBJECT *object;

	// Switch on the request.
	if (!objectID) objectID = ID_TOOL_BAR;
	switch (request)
	{
	case INITIALIZE_CLASS:
		searchID = windowID[0] = ID_TOOL_BAR;
		windowID[1] = ID_WINDOW;
		// Continue to CHANGED_FLAGS.
	case CHANGED_FLAGS:
#ifdef _WINDOWS
		if (request == CHANGED_FLAGS)
			UIW_WINDOW::Information(CHANGED_FLAGS, data, ID_TOOL_BAR);
		if (screenID && request == CHANGED_FLAGS && objectID == ID_TOOL_BAR)
		{
			DestroyWindow(screenID);
			if (FlagSet(woFlags, WOF_NON_FIELD_REGION))
			{
				RegisterObject("UIW_TOOL_BAR", NULL, &_toolbarOffset,
					&_toolbarJumpInstance, &_toolbarCallback, NULL);
				SendMessage(screenID, WM_SETREDRAW, FALSE, 0);
				UI_EVENT event(S_CREATE);
				for (object = First(); object; object = object->Next())
					object->Event(event);
			}
			else
				Event(UI_EVENT(S_CREATE));
			SetWindowPos(screenID, previous ? Previous()->screenID : 0,
				0, 0, 0, 0, SWP_NOMOVE | SWP_NOSIZE | SWP_NOREDRAW);
		}
#else
		if (screenID && request == CHANGED_FLAGS && objectID == ID_TOOL_BAR)
		{
			if (FlagSet(woFlags, WOF_NON_FIELD_REGION))
				return (parent->Information(request, data));
			UI_EVENT event(S_INITIALIZE);
			Event(event);
			event.type = S_CREATE;
			Event(event);
		}
#endif
		break;

	default:
		data = UIW_WINDOW::Information(request, data, objectID);
		break;
	}

	// Return the information.
	return (data);
}

// ----- ZIL_PERSISTENCE ----------------------------------------------------

#ifdef ZIL_PERSISTENCE
UIW_TOOL_BAR::UIW_TOOL_BAR(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file) :
	UIW_WINDOW(0, 0, 20, 6, WOF_NO_FLAGS)
{
	// Initialize the text information.
	UIW_TOOL_BAR::Load(name, directory, file);
	UI_WINDOW_OBJECT::Information(INITIALIZE_CLASS, NULL);
	UIW_WINDOW::Information(INITIALIZE_CLASS, NULL);
	UIW_TOOL_BAR::Information(INITIALIZE_CLASS, NULL);
}

void UIW_TOOL_BAR::Load(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Load the toolbar information.
	UIW_WINDOW::Load(name, directory, file);
}

void UIW_TOOL_BAR::Store(const char *name, UI_STORAGE *directory, UI_STORAGE_OBJECT *file)
{
	// Store the toolbar information.
	UIW_WINDOW::Store(name, directory, file);
}
#endif

