# HELLO tutorial makefile

# Uses Borland C++ 3.00 and Zinc Interface Library Version 3.00 

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB

#    make -fborland.mak hello1.exe      (makes the hello1 tutorial program)
#    make -fborland.mak hello2.exe      (makes the hello2 tutorial program)
#    make -fborland.mak hello3.exe      (makes the hello3 tutorial program)
#    make -fborland.mak hellog.exe      (makes program to generate HELLO.DAT file)
#    make -fborland.mak whello1.exe     (makes the Windows hello1 program)
#    make -fborland.mak whello2.exe     (makes the Windows hello2 program)
#    make -fborland.mak whello3.exe     (makes the Windows hello3 program)

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bcc
LINK=tlink
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
WIN_CPP_OPTS=-c -ml -O -WE -w
WIN_LINK_OPTS=/c /C /Twe /x

## Libraries:
DOS_OBJS=c0l
DOS_LIBS=zil graphics emu mathl cl
WIN_OBJS=c0wl
WIN_LIBS=zilw mathwl import cwl


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }


all: hello1.exe hello2.exe hello3.exe hellog.exe whello1.exe whello2.exe whello3.exe


hello1.exe: hello1.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+hello1.obj
$*, ,$(DOS_LIBS)
!


hello2.exe: hello2.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+hello2.obj
$*, ,$(DOS_LIBS)
!


hello3.exe: hello3.obj hello.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+hello3.obj+hello.obj
$*, ,$(DOS_LIBS)
!


hellog.exe: hellog.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+hellog.obj
$*, ,$(DOS_LIBS)
!


whello1.exe: hello1.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+hello1.obw
$*, ,$(WIN_LIBS),whello.def
!
	rc whello.rc $<


whello2.exe: hello2.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+hello2.obw
$*, ,$(WIN_LIBS),whello.def
!
	rc whello.rc $<


whello3.exe: hello3.obw hello.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+hello3.obw+hello.obw
$*, ,$(WIN_LIBS),whello.def
!
	rc whello.rc $<
