//	HELLOG.CPP (HELLO) - Generate the HELLO.DAT windows.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>

#define USE_HELP_CONTEXTS
#include "hello.hpp"

static UIW_WINDOW *HelloWorldWindow1()
{
	// Create the standard Hello World! window.
	UIW_WINDOW *window = UIW_WINDOW::Generic(2, 2, 40, 6, "Hello World Window",
		NULL, WOF_NO_FLAGS, WOAF_NO_FLAGS, HELP_HELLO_WORLD);

	// Add the window objects to the window.
	*window
		+ new UIW_TEXT(0, 0, 0, 0, "Hello, World!", 256,
			WNF_NO_FLAGS, WOF_NON_FIELD_REGION);

	// Return a pointer to the window.
	return (window);
}

static UIW_WINDOW *HelloWorldWindow2()
{
	// Create the world information window.
	UIW_WINDOW *window = UIW_WINDOW::Generic(5, 5, 52, 15, "World Information Window",
		NULL, WOF_NO_FLAGS, WOAF_NO_SIZE, HELP_WORLD_INFORMATION);

	// Add the window objects to the window.
	*window
		+ new UIW_PROMPT(2, 1, "Age:")
		+ new UIW_STRING(12, 1, 36, "At least 4 1/2 billion years.", 50)

		+ new UIW_PROMPT(2, 2, "Weight:")
		+ new UIW_STRING(12, 2, 36, "6.0 sextillion metric tons.", 50)

		+ new UIW_PROMPT(2, 3, "Size:")
		+ new UIW_STRING(12, 3, 36, "24,901.55 miles circumference.", 50)

		+ new UIW_PROMPT(2, 4, "Makeup:")
		+ &(*new UIW_VT_LIST(12, 4, 20, 4)
			+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL)
			+ new UIW_STRING(0, 0, 0, "oxygen -- 46.6%")
			+ new UIW_STRING(0, 0, 0, "silicon -- 27.7%")
			+ new UIW_STRING(0, 0, 0, "aluminum -- 8.1%")
			+ new UIW_STRING(0, 0, 0, "iron -- 5.0%")
			+ new UIW_STRING(0, 0, 0, "calcium -- 3.6%")
			+ new UIW_STRING(0, 0, 0, "other -- 9.0%"))

		+ &(*new UIW_TEXT(2, 8, 44, 4,
			"The earth is the third planet in distance outward "
			"from the sun.  It is the only planetary body in the "
			"solar system known to have conditions suitable for life.",
			2048, WNF_NO_FLAGS, WOF_BORDER)
			+ new UIW_SCROLL_BAR(0, 0, 0, 0, SBF_VERTICAL));

	// Return a pointer to the window.
	return (window);
}

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Create the window manager.
	UI_WINDOW_MANAGER *windowManager = new UI_WINDOW_MANAGER(display, eventManager);

	// Add two windows to the hello.dat object file as window resources.
	UIW_WINDOW *window1 = HelloWorldWindow1();
	window1->Store("hello.dat~HELLO_WORLD_WINDOW");

	UIW_WINDOW *window2 = HelloWorldWindow2();
	window2->Store("hello.dat~WORLD_INFORMATION_WINDOW");

	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
