# HELLO tutorial makefile

# Uses Microsoft C++ 7.00 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_M70;C:\C700\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\C700\INCLUDE

#    make -fmicrosft.mak hello1.exe      (makes the hello1 tutorial program)
#    make -fmicrosft.mak hello2.exe      (makes the hello2 tutorial program)
#    make -fmicrosft.mak hello3.exe      (makes the hello3 tutorial program)
#    make -fmicrosft.mak hellog.exe      (makes program to generate HELLO.DAT file)
#    make -fmicrosft.mak whello1.exe     (makes the Windows hello1 program)
#    make -fmicrosft.mak whello2.exe     (makes the Windows hello2 program)
#    make -fmicrosft.mak whello3.exe     (makes the Windows hello3 program)

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=cl
LINK=link
DOS_CPP_OPTS=-c -AL -BATCH
DOS_LINK_OPTS=/NOI /BATCH /STACK:5120 /SEGMENTS:256
WIN_CPP_OPTS=-c -AL -BATCH -Gw -DWINVER=0x0300
WIN_LINK_OPTS=/NOD /NOI /BATCH /STACK:5120 /SEGMENTS:256

## Libraries:
DOS_OBJS=
DOS_LIBS=zil graphics oldnames
WIN_OBJS=
WIN_LIBS=zilw libw llibcew oldnames


.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -Fo$*.obw $<


all: hello1.exe hello2.exe hello3.exe hellog.exe whello1.exe whello2.exe whello3.exe


hello1.exe: hello1.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+hello1.obj
$*,NUL,$(DOS_LIBS),NUL
<<


hello2.exe: hello2.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+hello2.obj
$*,NUL,$(DOS_LIBS),NUL
<<


hello3.exe: hello3.obj hello.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+hello3.obj+hello.obj
$*,NUL,$(DOS_LIBS),NUL
<<


hellog.exe: hellog.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+hellog.obj
$*,NUL,$(DOS_LIBS),NUL
<<


whello1.exe: hello1.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+hello1.obw
$*,NUL,$(WIN_LIBS),whello.def
<<
	rc -30 -k whello.rc $*.exe


whello2.exe: hello2.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+hello2.obw
$*,NUL,$(WIN_LIBS),whello.def
<<
	rc -30 -k whello.rc $*.exe


whello3.exe: hello3.obw hello.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+hello3.obw+hello.obw
$*,NUL,$(WIN_LIBS),whello.def
<<
	rc -30 -k whello.rc $*.exe
