# PERSIST tutorial makefile

# Uses Borland C++ 3.00 and Zinc Interface Library Version 3.00 

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB_B30;C:BORLANDC\LIB

#    make -fborland.mak persist1.exe      (makes the persist1 tutorial program)
#    make -fborland.mak persist2.exe      (makes the persist2 tutorial program)
#    make -fborland.mak persist3.exe      (makes the persist3 tutorial program)
#    make -fborland.mak persist4.exe      (makes the persist4 tutorial program)
#    make -fborland.mak persist5.exe      (makes the persist5 tutorial program)
#    make -fborland.mak persist6.exe      (makes the persist6 tutorial program)
#    make -fborland.mak persist7.exe      (makes the persist7 tutorial program)
#    make -fborland.mak persist8.exe      (makes the persist8 tutorial program)

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)
CPP=bcc
LINK=tlink
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
WIN_CPP_OPTS=-c -ml -O -WE -w
WIN_LINK_OPTS=/c /C /Twe /x

## Libraries:
DOS_OBJS=c0l
DOS_LIBS=zil graphics emu mathl cl
WIN_OBJS=c0wl
WIN_LIBS=zilw mathwl import cwl


.c.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.c.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }


all: persist1.exe persist2.exe persist3.exe persist4.exe persist5.exe persist6.exe persist7.exe persist8.exe


persist1.exe: persist1.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist1.obj
$*, ,$(DOS_LIBS)
!


persist2.exe: persist2.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist2.obj+draw.obj
$*, ,$(DOS_LIBS)
!


persist3.exe: persist3.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist3.obj+draw.obj
$*, ,$(DOS_LIBS)
!


persist4.exe: persist4.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist4.obj+draw.obj
$*, ,$(DOS_LIBS)
!


persist5.exe: persist5.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist5.obj+draw.obj
$*, ,$(DOS_LIBS)
!


persist6.exe: persist6.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist6.obj+draw.obj
$*, ,$(DOS_LIBS)
!


persist7.exe: persist7.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+persist7.obj+draw.obj
$*, ,$(DOS_LIBS)
!


persist8.exe: persist8.obw draw.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+persist8.obw draw.obw
$*, ,$(WIN_LIBS),persist8.def
!
	rc persist8.rc $<
