# PERSIST tutorial makefile

# Uses Microsoft C++ 7.00 and Zinc Interface Library Version 3.00 

# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
#    set LIB=.;C:\ZINC\LIB_M70;C:\C700\LIB
#    set INCLUDE=.;C:\ZINC\INCLUDE;C:\C700\INCLUDE

#    make -fmicrosft.mak persist1.exe      (makes the persist1 tutorial program)
#    make -fmicrosft.mak persist2.exe      (makes the persist2 tutorial program)
#    make -fmicrosft.mak persist3.exe      (makes the persist3 tutorial program)
#    make -fmicrosft.mak persist4.exe      (makes the persist4 tutorial program)
#    make -fmicrosft.mak persist5.exe      (makes the persist5 tutorial program)
#    make -fmicrosft.mak persist6.exe      (makes the persist6 tutorial program)
#    make -fmicrosft.mak persist7.exe      (makes the persist7 tutorial program)
#    make -fmicrosft.mak persist8.exe      (makes the persist8 tutorial program)

## Compiler and linker: (Add -Zi to CPP_OPTS and /CO to LINK_OPTS for debug.)
CPP=cl
LINK=link
DOS_CPP_OPTS=-c -AL -BATCH
DOS_LINK_OPTS=/NOI /BATCH /STACK:5120 /SEGMENTS:256
WIN_CPP_OPTS=-c -AL -BATCH -Gw -DWINVER=0x0300
WIN_LINK_OPTS=/NOD /NOI /BATCH /STACK:5120 /SEGMENTS:256

## Libraries:
DOS_OBJS=
DOS_LIBS=zil graphics oldnames
WIN_OBJS=
WIN_LIBS=zilw libw llibcew oldnames


.c.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) $<

.c.obw:
	$(CPP) $(WIN_CPP_OPTS) -Fo$*.obw $<

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -Fo$*.obw $<


all: persist1.exe persist2.exe persist3.exe persist4.exe persist5.exe persist6.exe persist7.exe persist8.exe


persist1.exe: persist1.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist1.obj
$*,NUL,$(DOS_LIBS),NUL
<<


persist2.exe: persist2.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist2.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<


persist3.exe: persist3.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist3.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<


persist4.exe: persist4.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist4.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<


persist5.exe: persist5.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist5.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<


persist6.exe: persist6.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist6.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<


persist7.exe: persist7.obj draw.obj
	$(LINK) $(DOS_LINK_OPTS) @<<zil.rsp
$(DOS_OBJS)+persist7.obj+draw.obj
$*,NUL,$(DOS_LIBS),NUL
<<


persist8.exe: persist8.obw draw.obw
	$(LINK) $(WIN_LINK_OPTS) @<<zil.rsp
$(WIN_OBJS)+persist8.obw+draw.obw
$*,NUL,$(WIN_LIBS),persist8.def
<<
	rc -30 -k persist8.rc $*.exe
