//	VLIST.HPP (VLIST) - This file contains the virtual list class definitions.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


class VIRTUAL_ELEMENT : public UIW_STRING
{
	friend class VIRTUAL_LIST;
public:
	int recordNumber;

	void DataSet(VIRTUAL_ELEMENT *element)
		{ UIW_STRING::DataSet(element->DataGet()); recordNumber = element->recordNumber; }
	void DataSet(int _recordNumber, char *string)
		{ UIW_STRING::DataSet(string); recordNumber = _recordNumber; }
	virtual EVENT_TYPE Event(const UI_EVENT &event);
	VIRTUAL_ELEMENT *Next(void) { return (VIRTUAL_ELEMENT *)next; }
	VIRTUAL_ELEMENT *Previous(void) { return (VIRTUAL_ELEMENT *)previous; }

private:
	int height;

	VIRTUAL_ELEMENT(int left, int top, int width, int _height, int length);
};

class VIRTUAL_LIST : public UIW_WINDOW
{
public:
	VIRTUAL_LIST(const char *fileName, int _recordLength);
	~VIRTUAL_LIST(void);

	virtual EVENT_TYPE Event(const UI_EVENT &event);

	VIRTUAL_ELEMENT *Current(void) { return (VIRTUAL_ELEMENT *)current; }
	VIRTUAL_ELEMENT *First(void) { return (VIRTUAL_ELEMENT *)first; }
	VIRTUAL_ELEMENT *Last(void) { return (VIRTUAL_ELEMENT *)last; }

	void LoadRecord(VIRTUAL_ELEMENT *element, int recordNumber);

private:
	FILE *file;
	const int recordLength;
	int numberOfRecords;
	int topRecordShowing;
	int numberShowing;
};
