//	WORD1B.HPP (WORD) - Dictionary tutorial, C to C++.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


class WORD : public UI_ELEMENT
{
public:
	char *string;

	WORD(const char *_string) { string = strdup(_string); }
	~WORD(void) { delete string; }

	WORD *Next(void) { return ((WORD *)next); }
};

class WORD_LIST : public UI_LIST
{
public:
	WORD *First(void) { return ((WORD *)first); }
};

class D_WORD : public UI_ELEMENT
{
public:
	char *string;
	char *definition;
	WORD_LIST antonymList;
	WORD_LIST synonymList;

	D_WORD(FILE *file);
	~D_WORD(void) { delete string; delete definition; }

	D_WORD *Next(void) { return ((D_WORD *)next); }
	void Print(void);
};

class D_WORD_LIST : public UI_LIST
{
public:
	static int FindWord(void *element, void *matchData)
		{ return(stricmp(((D_WORD *)element)->string, (char *)matchData)); }

	D_WORD *First(void) { return ((D_WORD *)first); }
};

class DICTIONARY : public D_WORD_LIST
{
public:
	int found;

	DICTIONARY(void);

	D_WORD *Get(const char *word) { return((D_WORD *)UI_LIST::Get(D_WORD_LIST::FindWord, (void *)word)); }
};
