//	HELP.CPP (ZINCAPP) - This file contains the "Help" options.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>
#include "zincapp.hpp"
#define USE_HELP_CONTEXTS
#include "support.hpp"

void CONTROL_WINDOW::OptionHelp(EVENT_TYPE item)
{
	// Declare the help message/context pairs.
	static struct HELP_PAIR
	{
		int itemValue;
		UI_HELP_CONTEXT helpContext;
	} helpTable[] =
	{
		{ MSG_HELP_KEYBOARD,	HELP_KEYBOARD },
		{ MSG_HELP_MOUSE,		HELP_MOUSE },
		{ MSG_HELP_COMMANDS,	HELP_COMMANDS },
		{ MSG_HELP_PROCEDURES,	HELP_PROCEDURES },
		{ MSG_HELP_OBJECTS,		HELP_OBJECTS },
		{ MSG_HELP_HELP,		HELP_HELP },
		{ MSG_HELP_ZINCAPP,		HELP_GENERAL },
		{ 0, 0 }	// End of array.
	};

	// Get the help context then call the help system.
	USHORT helpContext = NO_HELP_CONTEXT;
	for (int i = 0; helpTable[i].itemValue; i++)
		if (item == helpTable[i].itemValue)
		{
			helpContext = helpTable[i].helpContext;
			break;
		}
	helpSystem->DisplayHelp(windowManager, helpContext);
}
