//	ZINCAPP.CPP (ZINCAPP) - This file contains the main program loop.
//	COPYRIGHT (C) 1990-1992.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <ui_win.hpp>
#include "zincapp.hpp"
#define USE_HELP_CONTEXTS
#include "support.hpp"

#ifdef _WINDOWS

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR, int nCmdShow)
{
	UI_DISPLAY *display = new UI_MSWINDOWS_DISPLAY(hInstance, hPrevInstance, nCmdShow);

#else

main()
{
	// Initialize the display (compiler dependent).
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)
	UI_DISPLAY *display = new UI_BGI_DISPLAY;
#endif
#ifdef __ZTC__
	UI_DISPLAY *display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER
	UI_DISPLAY *display = new UI_MSC_DISPLAY;
#endif

	// Install a text display if no graphics capability.
	if (!display->installed)
	{
		delete display;
		display = new UI_TEXT_DISPLAY;
	}

#endif

	// Create the event manager and add devices.
	UI_EVENT_MANAGER *eventManager = new UI_EVENT_MANAGER(display);
	*eventManager
		+ new UID_KEYBOARD
		+ new UID_MOUSE
		+ new UID_CURSOR;

	// Initialize the zinc application window manager and add the control window.
	ZINCAPP_WINDOW_MANAGER *windowManager = new ZINCAPP_WINDOW_MANAGER(display, eventManager);
	UIW_WINDOW *window = new CONTROL_WINDOW;
	*windowManager + window;

	// This line assigns the exit function to be called before the control
	// window is closed.  It MUST be after the window is added to windowManager.
	windowManager->screenID = window->screenID;

	// Initialize the help and error systems.
	UI_WINDOW_OBJECT::errorSystem = new UI_ERROR_SYSTEM;
	UI_WINDOW_OBJECT::helpSystem = new UI_HELP_SYSTEM("support.dat",
		windowManager, HELP_GENERAL);

	// Wait for user response.
	EVENT_TYPE ccode;
	do
	{
		// Get input from the user.
		UI_EVENT event;
		eventManager->Get(event);

		// Check for a screen reset message.
		if (event.type == S_RESET_DISPLAY)
		{
#ifndef _WINDOWS
			event.data = NULL;

			// Tell the managers we changed the display.
			windowManager->Event(event);
			eventManager->Event(event);

			delete display;
			if (event.rawCode == TDM_NONE)
#ifdef __ZTC__ 	// Zortech compiler.
				display = new UI_FG_DISPLAY;
#endif
#ifdef _MSC_VER	// Microsoft compiler.
				display = new UI_MSC_DISPLAY;
#endif
#if defined(__BCPLUSPLUS__) | defined(__TCPLUSPLUS__)	// Borland compiler.
				display = new UI_BGI_DISPLAY;
#endif
			else
				display = new UI_TEXT_DISPLAY(event.rawCode);
			if (!display->installed)
			{
				delete display;
				display = new UI_TEXT_DISPLAY;
			}

			// Tell the managers we changed the display.
			event.data = display;
			eventManager->Event(event);
			ccode = windowManager->Event(event);
#endif
		}
		else
			ccode = windowManager->Event(event);
	} while (ccode != L_EXIT && ccode != S_NO_OBJECT);

	// Clean up.
	delete UI_WINDOW_OBJECT::helpSystem;
	delete UI_WINDOW_OBJECT::errorSystem;
	delete windowManager;
	delete eventManager;
	delete display;

	return (0);
}
