//	DIRECT.HPP (DIRECT) - File directory program.
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/

//  May be freely copied, used and distributed.

typedef UIF_FLAGS DIF_FLAGS;
const DIF_FLAGS DIF_OK					= 0x0001;
const DIF_FLAGS DIF_YES					= 0x0002;
const DIF_FLAGS DIF_NO					= 0x0004;
const DIF_FLAGS DIF_CANCEL				= 0x0008;
const DIF_FLAGS DIF_ABORT				= 0x0010;
const DIF_FLAGS DIF_RETRY				= 0x0020;

const USER_EVENT FILE_FIRST			  	= 10000;
const USER_EVENT FILE_NEW			  	= 10000;
const USER_EVENT FILE_FOPEN			  	= 10001;
const USER_EVENT FILE_SAVE			  	= 10002;
const USER_EVENT FILE_SAVE_AS		  	= 10003;
const USER_EVENT FILE_CHANGE_DRIVE	  	= 10004;
const USER_EVENT FILE_CHANGE_DIRECTORY	= 10005;
const USER_EVENT FILE_CHANGE_FILE		= 10006;
const USER_EVENT FILE_DELETE			= 10007;
const USER_EVENT FILE_PREFERENCES		= 10009;
const USER_EVENT FILE_EXIT				= 10011;
const USER_EVENT FILE_SET_NAME			= 10012;
const USER_EVENT FILE_CHANGE_PATH	  	= 10013;
const USER_EVENT FILE_LAST			  	= 10013;
const USER_EVENT FILE_STATS			  	= 10014;

const USER_EVENT DIALOG_FIRST			= 10700;
const USER_EVENT DIALOG_OK				= 10700;
const USER_EVENT DIALOG_CANCEL			= 10701;
const USER_EVENT DIALOG_YES				= 10702;
const USER_EVENT DIALOG_NO				= 10703;
const USER_EVENT DIALOG_ABORT			= 10704;
const USER_EVENT DIALOG_RETRY			= 10705;
const USER_EVENT DIALOG_LAST			= 10706;

const USER_EVENT OPTION_NEW				= 10400;
const USER_EVENT OPTION_LOAD			= 10401;
const USER_EVENT OPTION_SAVE			= 10402;
const USER_EVENT OPTION_SAVE_AS			= 10403;
const USER_EVENT OPTION_DELETE			= 10404;
const USER_EVENT OPTION_EXIT			= 10405;
const USER_EVENT OPTION_OK				= 10406;
const USER_EVENT OPTION_CANCEL			= 10407;
const USER_EVENT OPTION_HELP			= 10408;
const USER_EVENT OPTION_ADD_ITEM		= 10410;

void Center(UIW_WINDOW *window);


class EXPORT FILE_WINDOW : public UIW_WINDOW
{
public:
	FILE_WINDOW(EVENT_TYPE ccode);
	virtual EVENT_TYPE Event(const UI_EVENT &event);

private:
	EVENT_TYPE option;
	UIW_STRING *name;
	UIW_STRING *directory;
	UIW_VT_LIST *drives;
	UIW_VT_LIST *directories;
	UIW_VT_LIST *files;
};

class DIALOG_WINDOW : public UIW_WINDOW
{
public:
	DIALOG_WINDOW(char *title, char *icon, DIF_FLAGS diFlags, char *format, ...);

	EVENT_TYPE Responce(void);
};

