# FREESTOR example makefile

#    make -fborland.mak dos		      	(makes the DOS freestore program)

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:\BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
DOS_OBJS=c0l
# --- Use the next line for UI_GRAPHICS_DISPLAY ---
DOS_LIBS=dos_zil dos_gfx bc_lgfx emu mathl cl
# --- Use the next line for UI_BGI_DISPLAY ---
#DOS_LIBS=dos_zil dos_bgi graphics emu mathl cl

CPP=bcc
LINK=tlink

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make this Zinc example for Borland C++ type:
	@echo make -fborland.mak dos
	@echo (Windows and OS/2 environments do not support this example)
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- DOS -----------------------------------------------------------------
dos: freestor.exe

freestor.exe: freestor.obj mem_err.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+freestor.obj+mem_err.obj
$*, ,$(DOS_LIBS)
!

windows:
	@echo (This tutorial is not supported in Windows or OS/2)

os2:
	@echo (This tutorial is not supported in Windows or OS/2)
