# PHONEBK example makefile

#    make -fborland.mak dos		      	(makes the DOS phonebk program)
#    make -fborland.mak windows	      	(makes the Windows phonebk program)
#    make -fborland.mak os2	      	 	(makes the OS/2 phonebk program)

# Be sure to update your TURBOC.CFG file to include the Zinc paths, e.g.:
#   -I.;C:\ZINC\INCLUDE;C:\BORLANDC\INCLUDE
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB
# and your TLINK.CFG file to include the Zinc paths, e.g.:
#   -L.;C:\ZINC\LIB\BTCPP310;C:\BORLANDC\LIB

## Compiler and linker: (Add -v to CPP_OPTS and /v to LINK_OPTS for debug.)

# ----- DOS compiler options ------------------------------------------------
DOS_CPP_OPTS=-c -ml -O -w
DOS_LINK_OPTS=/c /x
DOS_OBJS=c0l
# --- Use the next line for UI_GRAPHICS_DISPLAY ---
DOS_LIBS=dos_zil dos_gfx bc_lgfx emu mathl cl
# --- Use the next line for UI_BGI_DISPLAY ---
#DOS_LIBS=dos_zil dos_bgi graphics emu mathl cl

# ----- Windows compiler options --------------------------------------------

# --- Use the next 2 lines for Windows 3.0 compatibility ---
WIN_CPP_OPTS=-c -ml -O -WE -w -DWINVER=0x0300
WIN_RC_OPTS=-k -30
# --- Use the next 2 lines for Windows 3.1 compatibility ---
#WIN_CPP_OPTS=-c -ml -O -WE -w
#WIN_RC_OPTS=-k
WIN_LINK_OPTS=/c /C /Twe /x
WIN_OBJS=c0wl
WIN_LIBS=win_zil mathwl import cwl

# ----- OS/2 compiler options -----------------------------------------------
OS2_CPP_OPTS=-c
OS2_LINK_OPTS=/c /B:0x10000 /aa
OS2_OBJS=c02.obj
OS2_LIBS=os2_zil.lib c2.lib os2.lib

CPP=bcc
LINK=tlink
RC=rc

.cpp.obj:
	$(CPP) $(DOS_CPP_OPTS) {$< }

.cpp.obw:
	$(CPP) $(WIN_CPP_OPTS) -o$*.obw {$< }

.cpp.obo:
	$(CPP) $(OS2_CPP_OPTS) -o$*.obo {$< }

# ----- Usage --------------------------------------------------------------
usage:
	@echo ...........
	@echo ...........
	@echo To make this Zinc example for Borland C++ type:
	@echo make -fborland.mak dos
	@echo make -fborland.mak windows
	@echo make -fborland.mak os2
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean:
	z_clean

# ----- DOS -----------------------------------------------------------------
dos: phonebk.exe

phonebk.exe: phonebk.obj phon_win.obj
	$(LINK) $(DOS_LINK_OPTS) @&&!
$(DOS_OBJS)+phonebk.obj+phon_win.obj
$*, ,$(DOS_LIBS)
!

# ----- Windows -------------------------------------------------------------
windows: wphonebk.exe

wphonebk.exe: phonebk.obw phon_win.obw
	$(LINK) $(WIN_LINK_OPTS) @&&!
$(WIN_OBJS)+phonebk.obw+phon_win.obw
$*, ,$(WIN_LIBS),wphonebk.def
!
	$(RC) $(WIN_RC_OPTS) wphonebk.rc $<

# ----- OS/2 ----------------------------------------------------------------
os2: ophonebk.exe

ophonebk.exe: phonebk.obo phon_win.obo
	$(LINK) $(OS2_LINK_OPTS) @&&!
$(OS2_OBJS)+phonebk.obo+phon_win.obo
$*, ,$(OS2_LIBS),ophonebk.def
!
	$(RC) ophonebk.rc $<
