//	Zinc Interface Library - Z_OBJECT.CPP
//	COPYRIGHT (C) 1990-1993.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA
/* This file is part of OpenZinc

OpenZinc is free software: You can redistribute it and/or modify it
 under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the license or
 (at your option) any later version.

OpenZinc is distributed in the hope that it will be useful,
but without ANY WARRANTY; without even the implied warranty of
MARCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU Lessor Public license for more details

You should have received a copy of the GNU Lessor Public License
along with OpenZinc. If not, see <http://www.gnu.org/licenses/>.
*/


#include <stddef.h>
#include "ui_dsn.hpp"
#if defined(_MSC_VER)
#pragma hdrstop					// Microsoft pre-compiled header pragma.
#endif

// ----- UIW_DERIVE_OBJECT ---------------------------------------------------------

#if defined(WIN32)
static WNDPROC _deriveCallback = NULL;
#else
static int _deriveOffset = -1;
static FARPROC _deriveCallback = (FARPROC)DefWindowProc;
long FAR PASCAL _export DeriveJumpProcedure(HWND hWnd, WORD wMsg, WORD wParam, LONG lParam)
{
	UIW_DERIVE_OBJECT *object = (UIW_DERIVE_OBJECT *)GetWindowLong(hWnd, _deriveOffset);
	return (object->Event(UI_EVENT(E_MSWINDOWS, hWnd, wMsg, wParam, lParam)));
}
static FARPROC _deriveJumpInstance = (FARPROC)DeriveJumpProcedure;
#endif

EVENT_TYPE UIW_DERIVE_OBJECT::Event(const UI_EVENT &event)
{
	// Switch on the event type.
	EVENT_TYPE ccode = LogicalEvent(event, ID_DERIVE_OBJECT);
	switch (ccode)
	{
	case S_CREATE:
	case S_SIZE:
		UI_WINDOW_OBJECT::Event(event);
#if defined(WIN32)
		RegisterObject("UIW_DERIVE_OBJECT", "STATIC", &_deriveCallback);
#else
		RegisterObject("UIW_DERIVE_OBJECT", "STATIC", &_deriveOffset,
			&_deriveJumpInstance, &_deriveCallback);
#endif
		if (ccode == S_SIZE && screenID != parent->screenID)
		{
			RECT winRegion;
			winRegion.left = true.left;
			winRegion.top = true.top;
			winRegion.right = true.right + 1;
			winRegion.bottom = true.bottom + 1;
			InvalidateRect(parent->screenID, &winRegion, TRUE);
			SetWindowPos(screenID, 0, 0, 0, true.Width(), true.Height(),
				SWP_NOMOVE | SWP_NOZORDER);
		}
		break;

	case S_REGISTER_OBJECT:
#if defined(WIN32)
		RegisterObject("UIW_DERIVE_OBJECT", "STATIC", &_deriveCallback);
#else
		RegisterObject("UIW_DERIVE_OBJECT", "STATIC", &_deriveOffset,
			&_deriveJumpInstance, &_deriveCallback);
#endif
		break;

	default:
		ccode = UI_WINDOW_OBJECT::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}
